/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.util.stream.IntStream;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.AggregatePhaseStrategy;
import org.apache.flink.table.planner.plan.logical.SessionWindowSpec;
import org.apache.flink.table.planner.plan.logical.SliceAttachedWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.TimeAttributeWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.WindowAttachedWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalExchange;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalGlobalWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLocalWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalWindowAggregate;
import org.apache.flink.table.planner.plan.rules.physical.FlinkExpandConversionRule;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.planner.utils.TableConfigUtils;

public class TwoStageOptimizedWindowAggregateRule
extends RelOptRule {
    public static final TwoStageOptimizedWindowAggregateRule INSTANCE = new TwoStageOptimizedWindowAggregateRule();

    private TwoStageOptimizedWindowAggregateRule() {
        super(TwoStageOptimizedWindowAggregateRule.operand(StreamPhysicalWindowAggregate.class, TwoStageOptimizedWindowAggregateRule.operand(StreamPhysicalExchange.class, TwoStageOptimizedWindowAggregateRule.operand(RelNode.class, TwoStageOptimizedWindowAggregateRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "TwoStageOptimizedWindowAggregateRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        StreamPhysicalWindowAggregate windowAgg = (StreamPhysicalWindowAggregate)call.rel(0);
        Object realInput = call.rel(2);
        TableConfig tableConfig = ShortcutUtils.unwrapContext(call.getPlanner()).getTableConfig();
        WindowingStrategy windowing = windowAgg.windowing();
        if (TableConfigUtils.getAggPhaseStrategy((ReadableConfig)tableConfig) == AggregatePhaseStrategy.ONE_PHASE) {
            return false;
        }
        if (!windowing.isRowtime()) {
            return false;
        }
        if (windowing.getWindow() instanceof SessionWindowSpec) {
            return false;
        }
        if (!AggregateUtil.doAllSupportPartialMerge(windowAgg.aggInfoList().aggInfos())) {
            return false;
        }
        return !this.isInputSatisfyRequiredDistribution((RelNode)realInput, windowAgg.grouping());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        StreamPhysicalWindowAggregate windowAgg = (StreamPhysicalWindowAggregate)call.rel(0);
        Object realInput = call.rel(2);
        WindowingStrategy windowing = windowAgg.windowing();
        RelTraitSet localTraitSet = realInput.getTraitSet();
        StreamPhysicalLocalWindowAggregate localAgg = new StreamPhysicalLocalWindowAggregate(windowAgg.getCluster(), localTraitSet, (RelNode)realInput, windowAgg.grouping(), windowAgg.aggCalls(), windowing);
        int[] globalGrouping = IntStream.range(0, windowAgg.grouping().length).toArray();
        FlinkRelDistribution globalDistribution = this.createDistribution(globalGrouping);
        RelNode newInput = FlinkExpandConversionRule.satisfyDistribution(FlinkConventions.STREAM_PHYSICAL(), localAgg, globalDistribution);
        RelTraitSet globalAggProvidedTraitSet = windowAgg.getTraitSet();
        int endIndex = localAgg.getRowType().getFieldCount() - 1;
        WindowingStrategy globalWindowing = windowing instanceof TimeAttributeWindowingStrategy ? new SliceAttachedWindowingStrategy(windowing.getWindow(), windowing.getTimeAttributeType(), endIndex) : new WindowAttachedWindowingStrategy(windowing.getWindow(), windowing.getTimeAttributeType(), endIndex);
        StreamPhysicalGlobalWindowAggregate globalAgg = new StreamPhysicalGlobalWindowAggregate(windowAgg.getCluster(), globalAggProvidedTraitSet, newInput, realInput.getRowType(), globalGrouping, windowAgg.aggCalls(), globalWindowing, windowAgg.namedWindowProperties());
        call.transformTo(globalAgg);
    }

    private boolean isInputSatisfyRequiredDistribution(RelNode input, int[] keys) {
        FlinkRelDistribution requiredDistribution = this.createDistribution(keys);
        FlinkRelDistribution inputDistribution = input.getTraitSet().getTrait(FlinkRelDistributionTraitDef.INSTANCE());
        return inputDistribution.satisfies(requiredDistribution);
    }

    private FlinkRelDistribution createDistribution(int[] keys) {
        if (keys.length > 0) {
            return FlinkRelDistribution.hash(keys, true);
        }
        return FlinkRelDistribution.SINGLETON();
    }
}

