/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.selector.settable;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;

public class SettableDimensionValueSelector
implements DimensionSelector,
SettableColumnValueSelector<Object> {
    @Nullable
    private DimensionSelector keptSelector;
    private final ArrayBasedIndexedInts keptRow = new ArrayBasedIndexedInts();

    @Override
    public void setValueFrom(ColumnValueSelector<?> selector) {
        DimensionSelector dimensionSelector;
        this.keptSelector = dimensionSelector = (DimensionSelector)selector;
        IndexedInts row = dimensionSelector.getRow();
        int rowSize = row.size();
        this.keptRow.ensureSize(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            this.keptRow.setValue(i, row.get(i));
        }
        this.keptRow.setSize(rowSize);
    }

    @Override
    public IndexedInts getRow() {
        return this.keptRow;
    }

    @Override
    public ValueMatcher makeValueMatcher(@Nullable String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getValueCardinality() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        return Objects.requireNonNull(this.keptSelector).lookupName(id);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return Objects.requireNonNull(this.keptSelector).nameLookupPossibleInAdvance();
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return Objects.requireNonNull(this.keptSelector).idLookup();
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.defaultGetObject();
    }

    @Override
    public Class classOfObject() {
        return Object.class;
    }
}

