/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.projections;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.projections.BaseTableProjectionSchema;
import org.apache.druid.utils.CollectionUtils;

public class TableProjectionSchema
implements BaseTableProjectionSchema {
    public static final String TYPE_NAME = "base-table";
    private final VirtualColumns virtualColumns;
    private final List<String> columnNames;
    private final AggregatorFactory[] aggregators;
    private final List<OrderBy> ordering;
    private final int timeColumnPosition;
    private final Granularity effectiveGranularity;

    public static TableProjectionSchema fromMetadata(List<String> dims, Metadata metadata) {
        return new TableProjectionSchema(VirtualColumns.create(Granularities.toVirtualColumn(metadata.getQueryGranularity(), "__virtualGranularity")), dims, metadata.getAggregators(), metadata.getOrdering());
    }

    @JsonCreator
    public TableProjectionSchema(@JsonProperty(value="virtualColumns") VirtualColumns virtualColumns, @JsonProperty(value="columns") List<String> columns, @JsonProperty(value="aggregators") @Nullable AggregatorFactory[] aggregators, @JsonProperty(value="ordering") List<OrderBy> ordering) {
        if (CollectionUtils.isNullOrEmpty(columns)) {
            throw DruidException.defensive("base table projection schema columns must not be null or empty", new Object[0]);
        }
        if (ordering == null) {
            throw DruidException.defensive("base table projection schema ordering must not be null", new Object[0]);
        }
        this.virtualColumns = virtualColumns == null ? VirtualColumns.EMPTY : virtualColumns;
        this.columnNames = columns;
        this.aggregators = aggregators == null ? new AggregatorFactory[]{} : aggregators;
        this.ordering = ordering;
        int foundTimePosition = -1;
        Granularity granularity = null;
        for (int i = 0; i < ordering.size(); ++i) {
            OrderBy orderBy = ordering.get(i);
            if (!orderBy.getColumnName().equals("__time")) continue;
            foundTimePosition = i;
            VirtualColumn vc = this.virtualColumns.getVirtualColumn("__virtualGranularity");
            granularity = vc != null ? Granularities.fromVirtualColumn(vc) : Granularities.NONE;
        }
        if (granularity == null) {
            throw DruidException.defensive("base table doesn't have a [%s] column?", "__time");
        }
        this.timeColumnPosition = foundTimePosition;
        this.effectiveGranularity = granularity;
    }

    @Override
    @JsonIgnore
    public List<String> getColumnNames() {
        ArrayList<String> columns = new ArrayList<String>(this.columnNames.size() + this.aggregators.length);
        columns.addAll(this.columnNames);
        for (AggregatorFactory aggregator : this.aggregators) {
            columns.add(aggregator.getName());
        }
        return columns;
    }

    @Override
    @JsonProperty
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @JsonProperty
    public List<String> getColumns() {
        return this.columnNames;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @Override
    @JsonIgnore
    public int getTimeColumnPosition() {
        return this.timeColumnPosition;
    }

    @Override
    @JsonIgnore
    public Granularity getEffectiveGranularity() {
        return this.effectiveGranularity;
    }

    @Override
    @JsonProperty
    public List<OrderBy> getOrdering() {
        return this.ordering;
    }

    @Override
    @JsonIgnore
    public List<String> getDimensionNames() {
        if (this.timeColumnPosition == 0) {
            return this.columnNames.subList(1, this.columnNames.size());
        }
        ArrayList dimsWithoutTime = Lists.newArrayListWithCapacity((int)(this.columnNames.size() - 1));
        for (String column : this.columnNames) {
            if ("__time".equals(column)) continue;
            dimsWithoutTime.add(column);
        }
        return dimsWithoutTime;
    }

    @Override
    public Metadata asMetadata(List<AggregateProjectionMetadata> projections) {
        return new Metadata(null, this.aggregators, null, this.effectiveGranularity, false, this.ordering, projections);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableProjectionSchema that = (TableProjectionSchema)o;
        return Objects.equals(this.virtualColumns, that.virtualColumns) && Objects.equals(this.columnNames, that.columnNames) && Objects.deepEquals(this.aggregators, that.aggregators) && Objects.equals(this.ordering, that.ordering);
    }

    public int hashCode() {
        return Objects.hash(this.virtualColumns, this.columnNames, Arrays.hashCode(this.aggregators), this.ordering);
    }

    public String toString() {
        return "TableProjectionSchema{virtualColumns=" + String.valueOf(this.virtualColumns) + ", columnNames=" + String.valueOf(this.columnNames) + ", aggregators=" + Arrays.toString(this.aggregators) + ", ordering=" + String.valueOf(this.ordering) + "}";
    }
}

