/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Exprs;
import org.apache.druid.math.expr.vector.BivariateFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.ExprEvalBindingVector;
import org.apache.druid.math.expr.vector.ExprEvalDoubleVector;
import org.apache.druid.math.expr.vector.ExprEvalLongVector;
import org.apache.druid.math.expr.vector.ExprEvalObjectVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.LongUnivariateDoubleFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.LongUnivariateLongFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.LongUnivariateObjectFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.SymmetricalBivariateFunctionVectorProcessor;
import org.apache.druid.segment.column.Types;

public class VectorProcessors {
    public static <T> ExprVectorProcessor<T> makeSymmetricalProcessor(Expr.VectorInputBindingInspector inspector, Expr left, Expr right, Supplier<ExprVectorProcessor<?>> longProcessor, Supplier<ExprVectorProcessor<?>> doubleProcessor, Supplier<ExprVectorProcessor<?>> objectProcessor) {
        ExpressionType leftType = left.getOutputType(inspector);
        if (leftType == null) {
            return right.asVectorProcessor(inspector);
        }
        Preconditions.checkArgument((boolean)inspector.areSameTypes(left, right), (String)"%s and %s are not the same type", (Object)leftType, (Object)right.getOutputType(inspector));
        ExprVectorProcessor<?> processor = null;
        if (Types.is(leftType, ExprType.STRING)) {
            processor = objectProcessor.get();
        } else if (Types.is(leftType, ExprType.LONG)) {
            processor = longProcessor.get();
        } else if (Types.is(leftType, ExprType.DOUBLE)) {
            processor = doubleProcessor.get();
        }
        if (processor == null) {
            throw Exprs.cannotVectorize();
        }
        return processor;
    }

    public static <T> ExprVectorProcessor<T> constant(@Nullable Object constant, int maxVectorSize, ExpressionType type) {
        if (type.isNumeric()) {
            throw DruidException.defensive("Type[%s] should use the numeric constant creator instead", type);
        }
        Object[] objects = new Object[maxVectorSize];
        Arrays.fill(objects, constant);
        ExprEvalObjectVector eval = new ExprEvalObjectVector(objects, type);
        return new ConstantVectorProcessor<Object[]>(eval, maxVectorSize);
    }

    public static <T> ExprVectorProcessor<T> constant(@Nullable Double constant, int maxVectorSize) {
        boolean[] nulls;
        double[] doubles = new double[maxVectorSize];
        if (constant == null) {
            nulls = new boolean[maxVectorSize];
            Arrays.fill(nulls, true);
        } else {
            nulls = null;
            Arrays.fill(doubles, constant);
        }
        ExprEvalDoubleVector eval = new ExprEvalDoubleVector(doubles, nulls);
        return new ConstantVectorProcessor<double[]>(eval, maxVectorSize);
    }

    public static <T> ExprVectorProcessor<T> constant(@Nullable Long constant, int maxVectorSize) {
        boolean[] nulls;
        long[] longs = new long[maxVectorSize];
        if (constant == null) {
            nulls = new boolean[maxVectorSize];
            Arrays.fill(nulls, true);
        } else {
            nulls = null;
            Arrays.fill(longs, constant);
        }
        ExprEvalLongVector eval = new ExprEvalLongVector(longs, nulls);
        return new ConstantVectorProcessor<long[]>(eval, maxVectorSize);
    }

    public static ExprVectorProcessor<?> identifier(Expr.VectorInputBindingInspector inspector, String binding) {
        ExpressionType inputType = inspector.getType(binding);
        return new IdentifierVectorProcessor(inputType == null ? ExpressionType.LONG : inputType, binding, inspector.getMaxVectorSize());
    }

    public static <T> ExprVectorProcessor<T> parseLong(final Expr.VectorInputBindingInspector inspector, Expr arg, final int radix) {
        LongUnivariateObjectFunctionVectorProcessor processor = new LongUnivariateObjectFunctionVectorProcessor(arg.asVectorProcessor(inspector), ExpressionType.STRING){

            @Override
            public int maxVectorSize() {
                return inspector.getMaxVectorSize();
            }

            @Override
            public void processIndex(Object[] strings, long[] longs, boolean[] outputNulls, int i) {
                try {
                    String input = (String)strings[i];
                    if (input == null) {
                        longs[i] = 0L;
                        outputNulls[i] = true;
                    } else {
                        longs[i] = radix == 16 && (input.startsWith("0x") || input.startsWith("0X")) ? Long.parseLong(input.substring(2), radix) : Long.parseLong(input, radix);
                        outputNulls[i] = false;
                    }
                }
                catch (NumberFormatException e) {
                    longs[i] = 0L;
                    outputNulls[i] = true;
                }
            }
        };
        return processor;
    }

    public static <T> ExprVectorProcessor<T> isNull(Expr.VectorInputBindingInspector inspector, Expr expr) {
        ExprVectorProcessor<long[]> processor;
        ExpressionType type = expr.getOutputType(inspector);
        if (type == null) {
            return VectorProcessors.constant(1L, inspector.getMaxVectorSize());
        }
        final long[] outputValues = new long[inspector.getMaxVectorSize()];
        if (Types.is(type, ExprType.LONG)) {
            final ExprVectorProcessor input = expr.asVectorProcessor(inspector);
            processor = new ExprVectorProcessor<long[]>(){

                @Override
                public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
                    ExprEvalVector inputEval = input.evalVector(bindings);
                    int currentSize = bindings.getCurrentVectorSize();
                    boolean[] nulls = inputEval.getNullVector();
                    if (nulls == null) {
                        Arrays.fill(outputValues, 0L);
                    } else {
                        for (int i = 0; i < currentSize; ++i) {
                            outputValues[i] = nulls[i] ? 1L : 0L;
                        }
                    }
                    return new ExprEvalLongVector(outputValues, null);
                }

                @Override
                public ExpressionType getOutputType() {
                    return ExpressionType.LONG;
                }

                @Override
                public int maxVectorSize() {
                    return outputValues.length;
                }
            };
        } else if (Types.is(type, ExprType.DOUBLE)) {
            final ExprVectorProcessor input = expr.asVectorProcessor(inspector);
            processor = new ExprVectorProcessor<long[]>(){

                @Override
                public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
                    ExprEvalVector inputEval = input.evalVector(bindings);
                    int currentSize = bindings.getCurrentVectorSize();
                    boolean[] nulls = inputEval.getNullVector();
                    if (nulls == null) {
                        Arrays.fill(outputValues, 0L);
                    } else {
                        for (int i = 0; i < currentSize; ++i) {
                            outputValues[i] = nulls[i] ? 1L : 0L;
                        }
                    }
                    return new ExprEvalLongVector(outputValues, null);
                }

                @Override
                public ExpressionType getOutputType() {
                    return ExpressionType.LONG;
                }

                @Override
                public int maxVectorSize() {
                    return outputValues.length;
                }
            };
        } else {
            final ExprVectorProcessor input = expr.asVectorProcessor(inspector);
            processor = new ExprVectorProcessor<long[]>(){

                @Override
                public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
                    ExprEvalVector inputEval = input.evalVector(bindings);
                    int currentSize = bindings.getCurrentVectorSize();
                    Object[] values = (Object[])inputEval.values();
                    for (int i = 0; i < currentSize; ++i) {
                        outputValues[i] = values[i] == null ? 1L : 0L;
                    }
                    return new ExprEvalLongVector(outputValues, null);
                }

                @Override
                public ExpressionType getOutputType() {
                    return ExpressionType.LONG;
                }

                @Override
                public int maxVectorSize() {
                    return outputValues.length;
                }
            };
        }
        return processor;
    }

    public static <T> ExprVectorProcessor<T> isNotNull(final Expr.VectorInputBindingInspector inspector, Expr expr) {
        ExprVectorProcessor<long[]> processor;
        ExpressionType type = expr.getOutputType(inspector);
        if (type == null) {
            return VectorProcessors.constant(0L, inspector.getMaxVectorSize());
        }
        final long[] outputValues = new long[inspector.getMaxVectorSize()];
        if (Types.is(type, ExprType.LONG)) {
            final ExprVectorProcessor input = expr.asVectorProcessor(inspector);
            processor = new ExprVectorProcessor<long[]>(){

                @Override
                public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
                    ExprEvalVector inputEval = input.evalVector(bindings);
                    int currentSize = bindings.getCurrentVectorSize();
                    boolean[] nulls = inputEval.getNullVector();
                    if (nulls == null) {
                        Arrays.fill(outputValues, 1L);
                    } else {
                        for (int i = 0; i < currentSize; ++i) {
                            outputValues[i] = nulls[i] ? 0L : 1L;
                        }
                    }
                    return new ExprEvalLongVector(outputValues, null);
                }

                @Override
                public ExpressionType getOutputType() {
                    return ExpressionType.LONG;
                }

                @Override
                public int maxVectorSize() {
                    return outputValues.length;
                }
            };
        } else if (Types.is(type, ExprType.DOUBLE)) {
            final ExprVectorProcessor input = expr.asVectorProcessor(inspector);
            processor = new ExprVectorProcessor<long[]>(){

                @Override
                public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
                    ExprEvalVector inputEval = input.evalVector(bindings);
                    int currentSize = bindings.getCurrentVectorSize();
                    boolean[] nulls = inputEval.getNullVector();
                    if (nulls == null) {
                        Arrays.fill(outputValues, 1L);
                    } else {
                        for (int i = 0; i < currentSize; ++i) {
                            outputValues[i] = nulls[i] ? 0L : 1L;
                        }
                    }
                    return new ExprEvalLongVector(outputValues, null);
                }

                @Override
                public ExpressionType getOutputType() {
                    return ExpressionType.LONG;
                }

                @Override
                public int maxVectorSize() {
                    return outputValues.length;
                }
            };
        } else {
            final ExprVectorProcessor input = expr.asVectorProcessor(inspector);
            processor = new ExprVectorProcessor<long[]>(){

                @Override
                public ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
                    ExprEvalVector inputEval = input.evalVector(bindings);
                    int currentSize = bindings.getCurrentVectorSize();
                    Object[] values = (Object[])inputEval.values();
                    for (int i = 0; i < currentSize; ++i) {
                        outputValues[i] = values[i] == null ? 0L : 1L;
                    }
                    return new ExprEvalLongVector(outputValues, null);
                }

                @Override
                public ExpressionType getOutputType() {
                    return ExpressionType.LONG;
                }

                @Override
                public int maxVectorSize() {
                    return inspector.getMaxVectorSize();
                }
            };
        }
        return processor;
    }

    public static <T> ExprVectorProcessor<T> not(Expr.VectorInputBindingInspector inspector, Expr expr) {
        ExpressionType inputType = expr.getOutputType(inspector);
        ExprVectorProcessor<long[]> processor = null;
        if (Types.is(inputType, ExprType.STRING)) {
            processor = new LongUnivariateObjectFunctionVectorProcessor(expr.asVectorProcessor(inspector), ExpressionType.STRING){

                @Override
                public void processIndex(Object[] strings, long[] longs, boolean[] outputNulls, int i) {
                    boolean bl = outputNulls[i] = strings[i] == null;
                    if (!outputNulls[i]) {
                        longs[i] = Evals.asLong(!Evals.asBoolean((String)strings[i]));
                    }
                }
            };
        } else if (Types.is(inputType, ExprType.LONG)) {
            processor = new LongUnivariateLongFunctionVectorProcessor(expr.asVectorProcessor(inspector), input -> Evals.asLong(!Evals.asBoolean(input)));
        } else if (Types.is(inputType, ExprType.DOUBLE)) {
            processor = new LongUnivariateDoubleFunctionVectorProcessor(expr.asVectorProcessor(inspector), input -> Evals.asLong(!Evals.asBoolean(input)));
        }
        if (processor == null) {
            throw Exprs.cannotVectorize();
        }
        return processor;
    }

    public static <T> ExprVectorProcessor<T> or(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        final int maxVectorSize = inspector.getMaxVectorSize();
        return VectorProcessors.makeSymmetricalProcessor(inspector, left, right, () -> new SymmetricalBivariateFunctionVectorProcessor<long[]>(ExpressionType.LONG, left.asVectorProcessor(inspector), right.asVectorProcessor(inspector)){
            final long[] output;
            final boolean[] outputNulls;
            {
                super(outputType, left, right);
                this.output = new long[maxVectorSize];
                this.outputNulls = new boolean[maxVectorSize];
            }

            @Override
            public void processIndex(long[] leftInput, @Nullable boolean[] leftNulls, long[] rightInput, @Nullable boolean[] rightNulls, int i) {
                boolean rightNull;
                boolean leftNull = leftNulls != null && leftNulls[i];
                boolean bl = rightNull = rightNulls != null && rightNulls[i];
                if (leftNull) {
                    if (rightNull) {
                        this.output[i] = 0L;
                        this.outputNulls[i] = true;
                        return;
                    }
                    boolean bool = Evals.asBoolean(rightInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = !bool;
                    return;
                }
                if (rightNull) {
                    boolean bool = Evals.asBoolean(leftInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = !bool;
                    return;
                }
                this.output[i] = Evals.asLong(Evals.asBoolean(leftInput[i]) || Evals.asBoolean(rightInput[i]));
                this.outputNulls[i] = false;
            }

            @Override
            public ExprEvalVector<long[]> asEval() {
                return new ExprEvalLongVector(this.output, this.outputNulls);
            }
        }, () -> new BivariateFunctionVectorProcessor<double[], double[], long[]>(ExpressionType.LONG, left.asVectorProcessor(inspector), right.asVectorProcessor(inspector)){
            final long[] output;
            final boolean[] outputNulls;
            {
                super(outputType, left, right);
                this.output = new long[maxVectorSize];
                this.outputNulls = new boolean[maxVectorSize];
            }

            @Override
            public void processIndex(double[] leftInput, @Nullable boolean[] leftNulls, double[] rightInput, @Nullable boolean[] rightNulls, int i) {
                boolean rightNull;
                boolean leftNull = leftNulls != null && leftNulls[i];
                boolean bl = rightNull = rightNulls != null && rightNulls[i];
                if (leftNull) {
                    if (rightNull) {
                        this.output[i] = 0L;
                        this.outputNulls[i] = true;
                        return;
                    }
                    boolean bool = Evals.asBoolean(rightInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = !bool;
                    return;
                }
                if (rightNull) {
                    boolean bool = Evals.asBoolean(leftInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = !bool;
                    return;
                }
                this.output[i] = Evals.asLong(Evals.asBoolean(leftInput[i]) || Evals.asBoolean(rightInput[i]));
                this.outputNulls[i] = false;
            }

            @Override
            public ExprEvalVector<long[]> asEval() {
                return new ExprEvalLongVector(this.output, this.outputNulls);
            }
        }, () -> new BivariateFunctionVectorProcessor<Object[], Object[], long[]>(ExpressionType.LONG, left.asVectorProcessor(inspector), right.asVectorProcessor(inspector)){
            final long[] output;
            final boolean[] outputNulls;
            {
                super(outputType, left, right);
                this.output = new long[maxVectorSize];
                this.outputNulls = new boolean[maxVectorSize];
            }

            @Override
            public void processIndex(Object[] leftInput, @Nullable boolean[] leftNulls, Object[] rightInput, @Nullable boolean[] rightNulls, int i) {
                boolean rightNull;
                boolean leftNull = leftInput[i] == null;
                boolean bl = rightNull = rightInput[i] == null;
                if (leftNull) {
                    if (rightNull) {
                        this.outputNulls[i] = true;
                        return;
                    }
                    boolean bool = Evals.asBoolean((String)rightInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = !bool;
                    return;
                }
                if (rightNull) {
                    boolean bool = Evals.asBoolean((String)leftInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = !bool;
                    return;
                }
                this.output[i] = Evals.asLong(Evals.asBoolean((String)leftInput[i]) || Evals.asBoolean((String)rightInput[i]));
                this.outputNulls[i] = false;
            }

            @Override
            public ExprEvalVector<long[]> asEval() {
                return new ExprEvalLongVector(this.output, this.outputNulls);
            }
        });
    }

    public static <T> ExprVectorProcessor<T> and(Expr.VectorInputBindingInspector inputTypes, Expr left, Expr right) {
        final int maxVectorSize = inputTypes.getMaxVectorSize();
        return VectorProcessors.makeSymmetricalProcessor(inputTypes, left, right, () -> new SymmetricalBivariateFunctionVectorProcessor<long[]>(ExpressionType.LONG, left.asVectorProcessor(inputTypes), right.asVectorProcessor(inputTypes)){
            final long[] output;
            final boolean[] outputNulls;
            {
                super(outputType, left, right);
                this.output = new long[maxVectorSize];
                this.outputNulls = new boolean[maxVectorSize];
            }

            @Override
            public void processIndex(long[] leftInput, @Nullable boolean[] leftNulls, long[] rightInput, @Nullable boolean[] rightNulls, int i) {
                boolean rightNull;
                boolean leftNull = leftNulls != null && leftNulls[i];
                boolean bl = rightNull = rightNulls != null && rightNulls[i];
                if (leftNull) {
                    if (rightNull) {
                        this.output[i] = 0L;
                        this.outputNulls[i] = true;
                        return;
                    }
                    boolean bool = Evals.asBoolean(rightInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = bool;
                    return;
                }
                if (rightNull) {
                    boolean bool = Evals.asBoolean(leftInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = bool;
                    return;
                }
                this.output[i] = Evals.asLong(Evals.asBoolean(leftInput[i]) && Evals.asBoolean(rightInput[i]));
                this.outputNulls[i] = false;
            }

            @Override
            public ExprEvalVector<long[]> asEval() {
                return new ExprEvalLongVector(this.output, this.outputNulls);
            }
        }, () -> new BivariateFunctionVectorProcessor<double[], double[], long[]>(ExpressionType.LONG, left.asVectorProcessor(inputTypes), right.asVectorProcessor(inputTypes)){
            final long[] output;
            final boolean[] outputNulls;
            {
                super(outputType, left, right);
                this.output = new long[maxVectorSize];
                this.outputNulls = new boolean[maxVectorSize];
            }

            @Override
            public void processIndex(double[] leftInput, @Nullable boolean[] leftNulls, double[] rightInput, @Nullable boolean[] rightNulls, int i) {
                boolean rightNull;
                boolean leftNull = leftNulls != null && leftNulls[i];
                boolean bl = rightNull = rightNulls != null && rightNulls[i];
                if (leftNull) {
                    if (rightNull) {
                        this.output[i] = 0L;
                        this.outputNulls[i] = true;
                        return;
                    }
                    boolean bool = Evals.asBoolean(rightInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = bool;
                    return;
                }
                if (rightNull) {
                    boolean bool = Evals.asBoolean(leftInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = bool;
                    return;
                }
                this.output[i] = Evals.asLong(Evals.asBoolean(leftInput[i]) && Evals.asBoolean(rightInput[i]));
                this.outputNulls[i] = false;
            }

            @Override
            public ExprEvalVector<long[]> asEval() {
                return new ExprEvalLongVector(this.output, this.outputNulls);
            }
        }, () -> new BivariateFunctionVectorProcessor<Object[], Object[], long[]>(ExpressionType.LONG, left.asVectorProcessor(inputTypes), right.asVectorProcessor(inputTypes)){
            final long[] output;
            final boolean[] outputNulls;
            {
                super(outputType, left, right);
                this.output = new long[maxVectorSize];
                this.outputNulls = new boolean[maxVectorSize];
            }

            @Override
            public void processIndex(Object[] leftInput, @Nullable boolean[] leftNulls, Object[] rightInput, @Nullable boolean[] rightNulls, int i) {
                boolean rightNull;
                boolean leftNull = leftInput[i] == null;
                boolean bl = rightNull = rightInput[i] == null;
                if (leftNull) {
                    if (rightNull) {
                        this.outputNulls[i] = true;
                        return;
                    }
                    boolean bool = Evals.asBoolean((String)rightInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = bool;
                    return;
                }
                if (rightNull) {
                    boolean bool = Evals.asBoolean((String)leftInput[i]);
                    this.output[i] = Evals.asLong(bool);
                    this.outputNulls[i] = bool;
                    return;
                }
                this.output[i] = Evals.asLong(Evals.asBoolean((String)leftInput[i]) && Evals.asBoolean((String)rightInput[i]));
                this.outputNulls[i] = false;
            }

            @Override
            public ExprEvalVector<long[]> asEval() {
                return new ExprEvalLongVector(this.output, this.outputNulls);
            }
        });
    }

    private VectorProcessors() {
    }

    static final class ConstantVectorProcessor<T>
    implements ExprVectorProcessor<T> {
        private final ExprEvalVector<T> constantVector;
        private final int maxVectorSize;

        ConstantVectorProcessor(ExprEvalVector<T> constantVector, int maxVectorSize) {
            this.constantVector = constantVector;
            this.maxVectorSize = maxVectorSize;
        }

        @Override
        public ExprEvalVector<T> evalVector(Expr.VectorInputBinding bindings) {
            return this.constantVector;
        }

        @Override
        public ExpressionType getOutputType() {
            return this.constantVector.getType();
        }

        @Override
        public int maxVectorSize() {
            return this.maxVectorSize;
        }
    }

    static final class IdentifierVectorProcessor<T>
    implements ExprVectorProcessor<T> {
        private final ExpressionType outputType;
        private final String bindingName;
        private final int maxVectorSize;

        public IdentifierVectorProcessor(ExpressionType outputType, String bindingName, int maxVectorSize) {
            this.outputType = outputType;
            this.bindingName = bindingName;
            this.maxVectorSize = maxVectorSize;
        }

        @Override
        public ExprEvalVector<T> evalVector(Expr.VectorInputBinding bindings) {
            return new ExprEvalBindingVector(this.outputType, bindings, this.bindingName);
        }

        @Override
        public ExpressionType getOutputType() {
            return this.outputType;
        }

        @Override
        public int maxVectorSize() {
            return this.maxVectorSize;
        }
    }
}

