/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import javax.annotation.Nullable;

public final class CartesianList<E>
extends AbstractList<List<E>>
implements RandomAccess {
    private final transient List<List<? extends E>> axes;
    private final transient int[] axesSizeProduct;

    public static <E> List<List<E>> create(List<? extends List<? extends E>> lists) {
        ArrayList<List<ArrayList<? extends E>>> axesBuilder = new ArrayList<List<ArrayList<? extends E>>>(lists.size());
        for (List<E> list : lists) {
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            axesBuilder.add(new ArrayList<E>(list));
        }
        return new CartesianList<E>(axesBuilder);
    }

    CartesianList(List<List<? extends E>> axes) {
        this.axes = axes;
        int[] axesSizeProduct = new int[axes.size() + 1];
        axesSizeProduct[axes.size()] = 1;
        try {
            for (int i = axes.size() - 1; i >= 0; --i) {
                axesSizeProduct[i] = IntMath.checkedMultiply((int)axesSizeProduct[i + 1], (int)axes.get(i).size());
            }
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("Cartesian product too large; must have size at most Integer.MAX_VALUE");
        }
        this.axesSizeProduct = axesSizeProduct;
    }

    private int getAxisIndexForProductIndex(int index, int axis) {
        return index / this.axesSizeProduct[axis + 1] % this.axes.get(axis).size();
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof List)) {
            return -1;
        }
        List list = (List)o;
        if (list.size() != this.axes.size()) {
            return -1;
        }
        ListIterator itr = list.listIterator();
        int computedIndex = 0;
        while (itr.hasNext()) {
            int axisIndex = itr.nextIndex();
            int elemIndex = this.axes.get(axisIndex).indexOf(itr.next());
            if (elemIndex == -1) {
                return -1;
            }
            computedIndex += elemIndex * this.axesSizeProduct[axisIndex + 1];
        }
        return computedIndex;
    }

    @Override
    public List<E> get(final int index) {
        Preconditions.checkElementIndex((int)index, (int)this.size());
        return new AbstractList<E>(){

            @Override
            public int size() {
                return CartesianList.this.axes.size();
            }

            @Override
            public E get(int axis) {
                Preconditions.checkElementIndex((int)axis, (int)this.size());
                int axisIndex = CartesianList.this.getAxisIndexForProductIndex(index, axis);
                return CartesianList.this.axes.get(axis).get(axisIndex);
            }
        };
    }

    @Override
    public int size() {
        return this.axesSizeProduct[0];
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.indexOf(o) != -1;
    }
}

