/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.granularity;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public abstract class BaseGranularitySpec
implements GranularitySpec {
    public static final Boolean DEFAULT_ROLLUP = Boolean.TRUE;
    public static final Granularity DEFAULT_SEGMENT_GRANULARITY = Granularities.DAY;
    public static final Granularity DEFAULT_QUERY_GRANULARITY = Granularities.NONE;
    protected final List<Interval> inputIntervals;
    protected final Boolean rollup;

    public BaseGranularitySpec(List<Interval> inputIntervals, Boolean rollup) {
        this.inputIntervals = inputIntervals == null ? Collections.emptyList() : inputIntervals;
        this.rollup = rollup == null ? DEFAULT_ROLLUP : rollup;
    }

    @Override
    @JsonProperty(value="intervals")
    public List<Interval> inputIntervals() {
        return this.inputIntervals;
    }

    @Override
    @JsonProperty(value="rollup")
    public boolean isRollup() {
        return this.rollup;
    }

    @Override
    public Optional<Interval> bucketInterval(DateTime dt) {
        return this.getLookupTableBuckets().bucketInterval(dt);
    }

    @Override
    public TreeSet<Interval> materializedBucketIntervals() {
        return this.getLookupTableBuckets().materializedIntervals();
    }

    protected abstract LookupIntervalBuckets getLookupTableBuckets();

    protected static class LookupIntervalBuckets {
        private final Iterable<Interval> intervalIterable;
        private final TreeSet<Interval> intervals;

        public LookupIntervalBuckets(Iterable<Interval> intervalIterable) {
            this.intervalIterable = intervalIterable;
            this.intervals = new TreeSet<Interval>(Comparators.intervalsByStartThenEnd());
        }

        public Optional<Interval> bucketInterval(DateTime dt) {
            Interval interval = this.materializedIntervals().floor(new Interval((ReadableInstant)dt, (ReadableInstant)DateTimes.MAX));
            if (interval != null && interval.contains((ReadableInstant)dt)) {
                return Optional.of((Object)interval);
            }
            return Optional.absent();
        }

        public Iterator<Interval> iterator() {
            return this.materializedIntervals().iterator();
        }

        public TreeSet<Interval> materializedIntervals() {
            if (this.intervalIterable != null && this.intervalIterable.iterator().hasNext() && this.intervals.isEmpty()) {
                Iterators.addAll(this.intervals, this.intervalIterable.iterator());
            }
            return this.intervals;
        }
    }
}

