/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor.autoscaler;

import java.util.Objects;

public class CostMetrics {
    private final double avgPartitionLag;
    private final int currentTaskCount;
    private final int partitionCount;
    private final double pollIdleRatio;
    private final long taskDurationSeconds;
    private final double avgProcessingRate;
    private double aggregateLag;

    public CostMetrics(double avgPartitionLag, int currentTaskCount, int partitionCount, double pollIdleRatio, long taskDurationSeconds, double avgProcessingRate) {
        this.avgPartitionLag = avgPartitionLag;
        this.currentTaskCount = currentTaskCount;
        this.partitionCount = partitionCount;
        this.pollIdleRatio = pollIdleRatio;
        this.taskDurationSeconds = taskDurationSeconds;
        this.avgProcessingRate = avgProcessingRate;
        this.aggregateLag = avgPartitionLag * (double)partitionCount;
    }

    public double getAvgPartitionLag() {
        return this.avgPartitionLag;
    }

    public int getCurrentTaskCount() {
        return this.currentTaskCount;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public double getPollIdleRatio() {
        return this.pollIdleRatio;
    }

    public double getAggregateLag() {
        return this.aggregateLag;
    }

    public long getTaskDurationSeconds() {
        return this.taskDurationSeconds;
    }

    public double getAvgProcessingRate() {
        return this.avgProcessingRate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CostMetrics that = (CostMetrics)o;
        return Double.compare(that.avgPartitionLag, this.avgPartitionLag) == 0 && this.currentTaskCount == that.currentTaskCount && this.partitionCount == that.partitionCount && Double.compare(that.pollIdleRatio, this.pollIdleRatio) == 0 && this.taskDurationSeconds == that.taskDurationSeconds && Double.compare(that.avgProcessingRate, this.avgProcessingRate) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.avgPartitionLag, this.currentTaskCount, this.partitionCount, this.pollIdleRatio, this.taskDurationSeconds, this.avgProcessingRate);
    }

    public String toString() {
        return "CostMetrics{avgPartitionLag=" + this.avgPartitionLag + ", currentTaskCount=" + this.currentTaskCount + ", partitionCount=" + this.partitionCount + ", pollIdleRatio=" + this.pollIdleRatio + ", taskDurationSeconds=" + this.taskDurationSeconds + ", avgProcessingRate=" + this.avgProcessingRate + "}";
    }
}

