/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import org.apache.druid.indexing.overlord.setup.FillCapacityWorkerSelectStrategy;
import org.apache.druid.indexing.overlord.setup.TaskLimits;
import org.apache.druid.indexing.overlord.setup.WorkerCategorySpec;
import org.apache.druid.indexing.overlord.setup.WorkerSelectStrategy;
import org.apache.druid.indexing.overlord.setup.WorkerSelectUtils;

public class FillCapacityWithCategorySpecWorkerSelectStrategy
implements WorkerSelectStrategy {
    private final WorkerCategorySpec workerCategorySpec;
    private final TaskLimits taskLimits;

    @JsonCreator
    public FillCapacityWithCategorySpecWorkerSelectStrategy(@JsonProperty(value="workerCategorySpec") WorkerCategorySpec workerCategorySpec, @JsonProperty(value="taskLimits") @Nullable TaskLimits taskLimits) {
        this.workerCategorySpec = workerCategorySpec;
        this.taskLimits = (TaskLimits)Configs.valueOrDefault((Object)taskLimits, (Object)TaskLimits.EMPTY);
    }

    @JsonProperty
    public WorkerCategorySpec getWorkerCategorySpec() {
        return this.workerCategorySpec;
    }

    @JsonProperty
    public TaskLimits getTaskLimits() {
        return this.taskLimits;
    }

    @Override
    @Nullable
    public ImmutableWorkerInfo findWorkerForTask(WorkerTaskRunnerConfig config, ImmutableMap<String, ImmutableWorkerInfo> zkWorkers, Task task) {
        return WorkerSelectUtils.selectWorker(task, zkWorkers, config, this.workerCategorySpec, FillCapacityWorkerSelectStrategy::selectFromEligibleWorkers, this.taskLimits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FillCapacityWithCategorySpecWorkerSelectStrategy that = (FillCapacityWithCategorySpecWorkerSelectStrategy)o;
        return Objects.equals(this.workerCategorySpec, that.workerCategorySpec) && Objects.equals(this.taskLimits, that.taskLimits);
    }

    public int hashCode() {
        return Objects.hash(this.workerCategorySpec, this.taskLimits);
    }

    public String toString() {
        return "FillCapacityWithCategorySpecWorkerSelectStrategy{workerCategorySpec=" + String.valueOf(this.workerCategorySpec) + ", taskLimits=" + String.valueOf(this.taskLimits) + "}";
    }
}

