/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.GlobalTaskLockbox;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskQueue;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.http.TaskStateLookup;
import org.apache.druid.indexing.overlord.http.TotalWorkerCapacityResponse;
import org.apache.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.LockFilterPolicy;
import org.apache.druid.metadata.TaskLookup;
import org.joda.time.Duration;
import org.joda.time.Interval;

public class TaskQueryTool {
    private final TaskStorage storage;
    private final GlobalTaskLockbox taskLockbox;
    private final TaskMaster taskMaster;
    private final Supplier<WorkerBehaviorConfig> workerBehaviorConfigSupplier;

    @Inject
    public TaskQueryTool(TaskStorage storage, GlobalTaskLockbox taskLockbox, TaskMaster taskMaster, Supplier<WorkerBehaviorConfig> workerBehaviorConfigSupplier) {
        this.storage = storage;
        this.taskLockbox = taskLockbox;
        this.taskMaster = taskMaster;
        this.workerBehaviorConfigSupplier = workerBehaviorConfigSupplier;
    }

    public Map<String, List<Interval>> getLockedIntervals(List<LockFilterPolicy> lockFilterPolicies) {
        return this.taskLockbox.getLockedIntervals(lockFilterPolicies);
    }

    public Map<String, List<TaskLock>> getActiveLocks(List<LockFilterPolicy> lockFilterPolicies) {
        return this.taskLockbox.getActiveLocks(lockFilterPolicies);
    }

    public List<TaskInfo> getActiveTaskInfo(@Nullable String dataSource) {
        return this.storage.getTaskInfos(TaskLookup.activeTasksOnly(), dataSource);
    }

    public Map<String, TaskStatus> getMultipleTaskStatuses(Set<String> taskIds) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)taskIds.size());
        for (String taskId : taskIds) {
            Optional<TaskStatus> optional = this.getTaskStatus(taskId);
            if (!optional.isPresent()) continue;
            result.put(taskId, (TaskStatus)optional.get());
        }
        return result;
    }

    public Optional<Task> getTask(String taskId) {
        Optional<Task> activeTask;
        Optional<TaskQueue> taskQueue = this.taskMaster.getTaskQueue();
        if (taskQueue.isPresent() && (activeTask = ((TaskQueue)taskQueue.get()).getActiveTask(taskId)).isPresent()) {
            return activeTask;
        }
        return this.storage.getTask(taskId);
    }

    public Optional<TaskStatus> getTaskStatus(String taskId) {
        Optional<TaskQueue> taskQueue = this.taskMaster.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getTaskStatus(taskId);
        }
        return this.storage.getStatus(taskId);
    }

    @Nullable
    public TaskInfo getTaskInfo(String taskId) {
        Optional<TaskInfo> taskStatus;
        Optional<TaskQueue> taskQueue = this.taskMaster.getTaskQueue();
        if (taskQueue.isPresent() && (taskStatus = ((TaskQueue)taskQueue.get()).getActiveTaskInfo(taskId)).isPresent()) {
            return (TaskInfo)taskStatus.get();
        }
        return this.storage.getTaskInfo(taskId);
    }

    public List<TaskStatusPlus> getAllActiveTasks() {
        Optional<TaskQueue> taskQueue = this.taskMaster.getTaskQueue();
        if (taskQueue.isPresent()) {
            ArrayList<TaskStatusPlus> taskStatusPlusList = new ArrayList<TaskStatusPlus>();
            List<TaskInfo> activeTasks = ((TaskQueue)taskQueue.get()).getTaskInfos();
            for (TaskInfo taskInfo : activeTasks) {
                Task task = taskInfo.getTask();
                TaskStatus status = taskInfo.getStatus();
                if (!status.isRunnable()) continue;
                taskStatusPlusList.add(new TaskStatusPlus(task.getId(), task.getGroupId(), task.getType(), taskInfo.getCreatedTime(), taskInfo.getCreatedTime(), status.getStatusCode(), null, Long.valueOf(status.getDuration()), status.getLocation(), task.getDataSource(), status.getErrorMsg()));
            }
            return taskStatusPlusList;
        }
        return this.getTaskStatusPlusList(TaskStateLookup.ALL, null, null, 0, null);
    }

    public List<TaskStatusPlus> getTaskStatusPlusList(TaskStateLookup state, @Nullable String dataSource, @Nullable String createdTimeInterval, @Nullable Integer maxCompletedTasks, @Nullable String type) {
        Duration createdTimeDuration;
        Optional<TaskRunner> taskRunnerOptional = this.taskMaster.getTaskRunner();
        if (!taskRunnerOptional.isPresent()) {
            return Collections.emptyList();
        }
        TaskRunner taskRunner = (TaskRunner)taskRunnerOptional.get();
        if (createdTimeInterval != null) {
            Interval theInterval = Intervals.of((String)StringUtils.replace((String)createdTimeInterval, (String)"_", (String)"/"));
            createdTimeDuration = theInterval.toDuration();
        } else {
            createdTimeDuration = null;
        }
        Stream<TaskStatusPlus> taskStatusPlusStream = this.retrieveTaskStatusesFromMetadataStore(state, dataSource, createdTimeDuration, maxCompletedTasks, type);
        Map<String, ? extends TaskRunnerWorkItem> runnerWorkItems = this.getTaskRunnerWorkItems(taskRunner, state, dataSource, type);
        if (state == TaskStateLookup.PENDING || state == TaskStateLookup.RUNNING) {
            taskStatusPlusStream = taskStatusPlusStream.filter(statusPlus -> runnerWorkItems.containsKey(statusPlus.getId()));
        }
        List taskStatusPlusList = taskStatusPlusStream.collect(Collectors.toList());
        ArrayList<TaskStatusPlus> completeTaskStatusPlusList = new ArrayList<TaskStatusPlus>();
        ArrayList<TaskStatusPlus> activeTaskStatusPlusList = new ArrayList<TaskStatusPlus>();
        for (TaskStatusPlus statusPlus2 : taskStatusPlusList) {
            if (statusPlus2.getStatusCode().isComplete()) {
                completeTaskStatusPlusList.add(statusPlus2);
                continue;
            }
            activeTaskStatusPlusList.add(statusPlus2);
        }
        ArrayList<TaskStatusPlus> taskStatuses = new ArrayList<TaskStatusPlus>(completeTaskStatusPlusList);
        activeTaskStatusPlusList.forEach(statusPlus -> {
            TaskRunnerWorkItem runnerWorkItem = (TaskRunnerWorkItem)runnerWorkItems.get(statusPlus.getId());
            if (runnerWorkItem == null) {
                if (state == TaskStateLookup.WAITING || state == TaskStateLookup.ALL) {
                    taskStatuses.add((TaskStatusPlus)statusPlus);
                }
            } else if (state == TaskStateLookup.PENDING || state == TaskStateLookup.RUNNING || state == TaskStateLookup.ALL) {
                taskStatuses.add(new TaskStatusPlus(statusPlus.getId(), statusPlus.getGroupId(), statusPlus.getType(), statusPlus.getCreatedTime(), runnerWorkItem.getQueueInsertionTime(), statusPlus.getStatusCode(), taskRunner.getRunnerTaskState(statusPlus.getId()), statusPlus.getDuration(), runnerWorkItem.getLocation(), statusPlus.getDataSource(), statusPlus.getErrorMsg()));
            }
        });
        return taskStatuses;
    }

    private Stream<TaskStatusPlus> retrieveTaskStatusesFromMetadataStore(TaskStateLookup state, @Nullable String dataSource, Duration createdTimeDuration, @Nullable Integer maxCompletedTasks, @Nullable String type) {
        ImmutableMap taskLookups;
        switch (state) {
            case ALL: {
                taskLookups = ImmutableMap.of((Object)TaskLookup.TaskLookupType.ACTIVE, (Object)TaskLookup.ActiveTaskLookup.getInstance(), (Object)TaskLookup.TaskLookupType.COMPLETE, (Object)TaskLookup.CompleteTaskLookup.of((Integer)maxCompletedTasks, (Duration)createdTimeDuration));
                break;
            }
            case COMPLETE: {
                taskLookups = ImmutableMap.of((Object)TaskLookup.TaskLookupType.COMPLETE, (Object)TaskLookup.CompleteTaskLookup.of((Integer)maxCompletedTasks, (Duration)createdTimeDuration));
                break;
            }
            case WAITING: 
            case PENDING: 
            case RUNNING: {
                taskLookups = ImmutableMap.of((Object)TaskLookup.TaskLookupType.ACTIVE, (Object)TaskLookup.ActiveTaskLookup.getInstance());
                break;
            }
            default: {
                throw new IAE("Unknown state: [%s]", new Object[]{state});
            }
        }
        Stream<TaskStatusPlus> taskStatusPlusStream = this.storage.getTaskStatusPlusList((Map<TaskLookup.TaskLookupType, TaskLookup>)taskLookups, dataSource).stream();
        if (type != null) {
            return taskStatusPlusStream.filter(statusPlus -> type.equals(statusPlus == null ? null : statusPlus.getType()));
        }
        return taskStatusPlusStream;
    }

    private Map<String, ? extends TaskRunnerWorkItem> getTaskRunnerWorkItems(TaskRunner taskRunner, TaskStateLookup state, @Nullable String dataSource, @Nullable String type) {
        Stream<Object> runnerWorkItemsStream;
        switch (state) {
            case ALL: 
            case WAITING: {
                runnerWorkItemsStream = taskRunner.getKnownTasks().stream();
                break;
            }
            case PENDING: {
                runnerWorkItemsStream = taskRunner.getPendingTasks().stream();
                break;
            }
            case RUNNING: {
                runnerWorkItemsStream = taskRunner.getRunningTasks().stream();
                break;
            }
            case COMPLETE: {
                runnerWorkItemsStream = Stream.empty();
                break;
            }
            default: {
                throw new IAE("Unknown state: [%s]", new Object[]{state});
            }
        }
        if (dataSource != null) {
            runnerWorkItemsStream = runnerWorkItemsStream.filter(item -> dataSource.equals(item.getDataSource()));
        }
        if (type != null) {
            runnerWorkItemsStream = runnerWorkItemsStream.filter(item -> type.equals(item.getTaskType()));
        }
        return runnerWorkItemsStream.collect(Collectors.toMap(TaskRunnerWorkItem::getTaskId, item -> item));
    }

    public TotalWorkerCapacityResponse getTotalWorkerCapacity() {
        Optional<TaskRunner> taskRunnerOptional = this.taskMaster.getTaskRunner();
        if (!taskRunnerOptional.isPresent()) {
            return null;
        }
        TaskRunner taskRunner = (TaskRunner)taskRunnerOptional.get();
        return new TotalWorkerCapacityResponse(taskRunner.getTotalCapacity(), taskRunner.getMaximumCapacityWithAutoscale(), taskRunner.getUsedCapacity());
    }

    public WorkerBehaviorConfig getLatestWorkerConfig() {
        return (WorkerBehaviorConfig)this.workerBehaviorConfigSupplier.get();
    }
}

