/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.SegmentLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TimeChunkLock;
import org.apache.druid.indexing.overlord.LockRequest;
import org.joda.time.Interval;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="granularity", defaultImpl=TimeChunkLock.class)
@JsonSubTypes(value={@JsonSubTypes.Type(name="timeChunk", value=TimeChunkLock.class), @JsonSubTypes.Type(name="segment", value=SegmentLock.class)})
public interface TaskLock {
    public TaskLock revokedCopy();

    public TaskLock withPriority(int var1);

    public LockGranularity getGranularity();

    public TaskLockType getType();

    public String getGroupId();

    public String getDataSource();

    public Interval getInterval();

    public String getVersion();

    @Nullable
    public Integer getPriority();

    public int getNonNullPriority();

    public boolean isRevoked();

    public boolean conflict(LockRequest var1);

    default public void assertNotRevoked() {
        if (this.isRevoked()) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("Lock of type[%s] for interval[%s] was revoked", new Object[]{this.getType(), this.getInterval()});
        }
    }
}

