/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.LoadPermissionModifications;
import com.amazonaws.services.ec2.model.LoadPermissionRequest;
import com.amazonaws.services.ec2.model.ModifyFpgaImageAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyFpgaImageAttributeRequestMarshaller
implements Marshaller<Request<ModifyFpgaImageAttributeRequest>, ModifyFpgaImageAttributeRequest> {
    public Request<ModifyFpgaImageAttributeRequest> marshall(ModifyFpgaImageAttributeRequest modifyFpgaImageAttributeRequest) {
        LoadPermissionModifications loadPermission;
        SdkInternalList modifyFpgaImageAttributeRequestProductCodesList;
        SdkInternalList modifyFpgaImageAttributeRequestUserGroupsList;
        SdkInternalList modifyFpgaImageAttributeRequestUserIdsList;
        if (modifyFpgaImageAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyFpgaImageAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyFpgaImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyFpgaImageAttributeRequest.getFpgaImageId() != null) {
            request.addParameter("FpgaImageId", StringUtils.fromString((String)modifyFpgaImageAttributeRequest.getFpgaImageId()));
        }
        if (modifyFpgaImageAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifyFpgaImageAttributeRequest.getAttribute()));
        }
        if (modifyFpgaImageAttributeRequest.getOperationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString((String)modifyFpgaImageAttributeRequest.getOperationType()));
        }
        if (!(modifyFpgaImageAttributeRequestUserIdsList = (SdkInternalList)modifyFpgaImageAttributeRequest.getUserIds()).isEmpty() || !modifyFpgaImageAttributeRequestUserIdsList.isAutoConstruct()) {
            int userIdsListIndex = 1;
            for (Object modifyFpgaImageAttributeRequestUserIdsListValue : modifyFpgaImageAttributeRequestUserIdsList) {
                if (modifyFpgaImageAttributeRequestUserIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString((String)modifyFpgaImageAttributeRequestUserIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        if (!(modifyFpgaImageAttributeRequestUserGroupsList = (SdkInternalList)modifyFpgaImageAttributeRequest.getUserGroups()).isEmpty() || !modifyFpgaImageAttributeRequestUserGroupsList.isAutoConstruct()) {
            int userGroupsListIndex = 1;
            for (Object modifyFpgaImageAttributeRequestUserGroupsListValue : modifyFpgaImageAttributeRequestUserGroupsList) {
                if (modifyFpgaImageAttributeRequestUserGroupsListValue != null) {
                    request.addParameter("UserGroup." + userGroupsListIndex, StringUtils.fromString((String)modifyFpgaImageAttributeRequestUserGroupsListValue));
                }
                ++userGroupsListIndex;
            }
        }
        if (!(modifyFpgaImageAttributeRequestProductCodesList = (SdkInternalList)modifyFpgaImageAttributeRequest.getProductCodes()).isEmpty() || !modifyFpgaImageAttributeRequestProductCodesList.isAutoConstruct()) {
            int productCodesListIndex = 1;
            for (String modifyFpgaImageAttributeRequestProductCodesListValue : modifyFpgaImageAttributeRequestProductCodesList) {
                if (modifyFpgaImageAttributeRequestProductCodesListValue != null) {
                    request.addParameter("ProductCode." + productCodesListIndex, StringUtils.fromString((String)modifyFpgaImageAttributeRequestProductCodesListValue));
                }
                ++productCodesListIndex;
            }
        }
        if ((loadPermission = modifyFpgaImageAttributeRequest.getLoadPermission()) != null) {
            SdkInternalList loadPermissionModificationsRemoveList;
            SdkInternalList loadPermissionModificationsAddList = (SdkInternalList)loadPermission.getAdd();
            if (!loadPermissionModificationsAddList.isEmpty() || !loadPermissionModificationsAddList.isAutoConstruct()) {
                int addListIndex = 1;
                for (LoadPermissionRequest loadPermissionModificationsAddListValue : loadPermissionModificationsAddList) {
                    if (loadPermissionModificationsAddListValue.getGroup() != null) {
                        request.addParameter("LoadPermission.Add." + addListIndex + ".Group", StringUtils.fromString((String)loadPermissionModificationsAddListValue.getGroup()));
                    }
                    if (loadPermissionModificationsAddListValue.getUserId() != null) {
                        request.addParameter("LoadPermission.Add." + addListIndex + ".UserId", StringUtils.fromString((String)loadPermissionModificationsAddListValue.getUserId()));
                    }
                    ++addListIndex;
                }
            }
            if (!(loadPermissionModificationsRemoveList = (SdkInternalList)loadPermission.getRemove()).isEmpty() || !loadPermissionModificationsRemoveList.isAutoConstruct()) {
                int removeListIndex = 1;
                for (LoadPermissionRequest loadPermissionModificationsRemoveListValue : loadPermissionModificationsRemoveList) {
                    if (loadPermissionModificationsRemoveListValue.getGroup() != null) {
                        request.addParameter("LoadPermission.Remove." + removeListIndex + ".Group", StringUtils.fromString((String)loadPermissionModificationsRemoveListValue.getGroup()));
                    }
                    if (loadPermissionModificationsRemoveListValue.getUserId() != null) {
                        request.addParameter("LoadPermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString((String)loadPermissionModificationsRemoveListValue.getUserId()));
                    }
                    ++removeListIndex;
                }
            }
        }
        if (modifyFpgaImageAttributeRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)modifyFpgaImageAttributeRequest.getDescription()));
        }
        if (modifyFpgaImageAttributeRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)modifyFpgaImageAttributeRequest.getName()));
        }
        return request;
    }
}

