/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeStoreImageTasksRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeStoreImageTasksRequestMarshaller
implements Marshaller<Request<DescribeStoreImageTasksRequest>, DescribeStoreImageTasksRequest> {
    public Request<DescribeStoreImageTasksRequest> marshall(DescribeStoreImageTasksRequest describeStoreImageTasksRequest) {
        SdkInternalList describeStoreImageTasksRequestFiltersList;
        if (describeStoreImageTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeStoreImageTasksRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeStoreImageTasks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeStoreImageTasksRequestImageIdsList = (SdkInternalList)describeStoreImageTasksRequest.getImageIds();
        if (!describeStoreImageTasksRequestImageIdsList.isEmpty() || !describeStoreImageTasksRequestImageIdsList.isAutoConstruct()) {
            int imageIdsListIndex = 1;
            for (String describeStoreImageTasksRequestImageIdsListValue : describeStoreImageTasksRequestImageIdsList) {
                if (describeStoreImageTasksRequestImageIdsListValue != null) {
                    request.addParameter("ImageId." + imageIdsListIndex, StringUtils.fromString((String)describeStoreImageTasksRequestImageIdsListValue));
                }
                ++imageIdsListIndex;
            }
        }
        if (!(describeStoreImageTasksRequestFiltersList = (SdkInternalList)describeStoreImageTasksRequest.getFilters()).isEmpty() || !describeStoreImageTasksRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeStoreImageTasksRequestFiltersListValue : describeStoreImageTasksRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeStoreImageTasksRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeStoreImageTasksRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeStoreImageTasksRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeStoreImageTasksRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeStoreImageTasksRequest.getNextToken()));
        }
        if (describeStoreImageTasksRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeStoreImageTasksRequest.getMaxResults()));
        }
        return request;
    }
}

