/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.SegmentDescriptor;
import org.joda.time.Interval;

public class RichSegmentDescriptor
extends SegmentDescriptor {
    @Nullable
    private final Interval fullInterval;

    public RichSegmentDescriptor(Interval fullInterval, Interval interval, String version, int partitionNumber) {
        super(interval, version, partitionNumber);
        this.fullInterval = interval.equals(Preconditions.checkNotNull((Object)fullInterval, (Object)"fullInterval")) ? null : fullInterval;
    }

    public RichSegmentDescriptor(SegmentDescriptor segmentDescriptor, @Nullable Interval fullInterval) {
        super(segmentDescriptor.getInterval(), segmentDescriptor.getVersion(), segmentDescriptor.getPartitionNumber());
        this.fullInterval = fullInterval;
    }

    @JsonCreator
    static RichSegmentDescriptor fromJson(@JsonProperty(value="fi") @Nullable Interval fullInterval, @JsonProperty(value="itvl") Interval interval, @JsonProperty(value="ver") String version, @JsonProperty(value="part") int partitionNumber) {
        return new RichSegmentDescriptor(fullInterval != null ? fullInterval : interval, interval, version, partitionNumber);
    }

    public Interval getFullInterval() {
        return this.fullInterval == null ? this.getInterval() : this.fullInterval;
    }

    @JsonProperty(value="fi")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Interval getFullIntervalForJson() {
        return this.fullInterval;
    }

    public SegmentDescriptor toPlainDescriptor() {
        return new SegmentDescriptor(this.getInterval(), this.getVersion(), this.getPartitionNumber());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RichSegmentDescriptor that = (RichSegmentDescriptor)((Object)o);
        return Objects.equals(this.fullInterval, that.fullInterval);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fullInterval);
    }

    public String toString() {
        return "RichSegmentDescriptor{fullInterval=" + String.valueOf(this.fullInterval == null ? this.getInterval() : this.fullInterval) + ", interval=" + String.valueOf(this.getInterval()) + ", version='" + this.getVersion() + "', partitionNumber=" + this.getPartitionNumber() + "}";
    }
}

