/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.NestedInputFormat;
import org.apache.druid.data.input.protobuf.ProtobufBytesDecoder;
import org.apache.druid.data.input.protobuf.ProtobufReader;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;

public class ProtobufInputFormat
extends NestedInputFormat {
    private final ProtobufBytesDecoder protobufBytesDecoder;

    @JsonCreator
    public ProtobufInputFormat(@JsonProperty(value="flattenSpec") @Nullable JSONPathSpec flattenSpec, @JsonProperty(value="protoBytesDecoder") ProtobufBytesDecoder protobufBytesDecoder) {
        super(flattenSpec);
        this.protobufBytesDecoder = protobufBytesDecoder;
    }

    @JsonProperty
    public ProtobufBytesDecoder getProtoBytesDecoder() {
        return this.protobufBytesDecoder;
    }

    public boolean isSplittable() {
        return false;
    }

    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        return new ProtobufReader(inputRowSchema, source, this.protobufBytesDecoder, this.getFlattenSpec());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ProtobufInputFormat that = (ProtobufInputFormat)((Object)o);
        return Objects.equals(this.getFlattenSpec(), that.getFlattenSpec()) && Objects.equals(this.protobufBytesDecoder, that.protobufBytesDecoder);
    }

    public int hashCode() {
        return Objects.hash(this.protobufBytesDecoder, this.getFlattenSpec());
    }
}

