/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.DBProxy;
import com.amazonaws.services.rds.model.UserAuthConfigInfo;
import com.amazonaws.services.rds.model.transform.UserAuthConfigInfoStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class DBProxyStaxUnmarshaller
implements Unmarshaller<DBProxy, StaxUnmarshallerContext> {
    private static DBProxyStaxUnmarshaller instance;

    public DBProxy unmarshall(StaxUnmarshallerContext context) throws Exception {
        DBProxy dBProxy = new DBProxy();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dBProxy;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DBProxyName", targetDepth)) {
                    dBProxy.setDBProxyName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBProxyArn", targetDepth)) {
                    dBProxy.setDBProxyArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    dBProxy.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineFamily", targetDepth)) {
                    dBProxy.setEngineFamily(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcId", targetDepth)) {
                    dBProxy.setVpcId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcSecurityGroupIds", targetDepth)) {
                    dBProxy.withVpcSecurityGroupIds(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("VpcSecurityGroupIds/member", targetDepth)) {
                    dBProxy.withVpcSecurityGroupIds(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcSubnetIds", targetDepth)) {
                    dBProxy.withVpcSubnetIds(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("VpcSubnetIds/member", targetDepth)) {
                    dBProxy.withVpcSubnetIds(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Auth", targetDepth)) {
                    dBProxy.withAuth(new ArrayList<UserAuthConfigInfo>());
                    continue;
                }
                if (context.testExpression("Auth/member", targetDepth)) {
                    dBProxy.withAuth(UserAuthConfigInfoStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RoleArn", targetDepth)) {
                    dBProxy.setRoleArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Endpoint", targetDepth)) {
                    dBProxy.setEndpoint(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequireTLS", targetDepth)) {
                    dBProxy.setRequireTLS(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IdleClientTimeout", targetDepth)) {
                    dBProxy.setIdleClientTimeout(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DebugLogging", targetDepth)) {
                    dBProxy.setDebugLogging(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreatedDate", targetDepth)) {
                    dBProxy.setCreatedDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (!context.testExpression("UpdatedDate", targetDepth)) continue;
                dBProxy.setUpdatedDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dBProxy;
    }

    public static DBProxyStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DBProxyStaxUnmarshaller();
        }
        return instance;
    }
}

