/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.join;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CompositeInputSplit
implements InputSplit {
    private int fill = 0;
    private long totsize = 0L;
    private InputSplit[] splits;

    public CompositeInputSplit() {
    }

    public CompositeInputSplit(int capacity) {
        this.splits = new InputSplit[capacity];
    }

    public void add(InputSplit s) throws IOException {
        if (null == this.splits) {
            throw new IOException("Uninitialized InputSplit");
        }
        if (this.fill == this.splits.length) {
            throw new IOException("Too many splits");
        }
        this.splits[this.fill++] = s;
        this.totsize += s.getLength();
    }

    public InputSplit get(int i) {
        return this.splits[i];
    }

    @Override
    public long getLength() throws IOException {
        return this.totsize;
    }

    public long getLength(int i) throws IOException {
        return this.splits[i].getLength();
    }

    @Override
    public String[] getLocations() throws IOException {
        HashSet<String> hosts = new HashSet<String>();
        for (InputSplit s : this.splits) {
            String[] hints = s.getLocations();
            if (hints == null || hints.length <= 0) continue;
            for (String host : hints) {
                hosts.add(host);
            }
        }
        return hosts.toArray(new String[hosts.size()]);
    }

    public String[] getLocation(int i) throws IOException {
        return this.splits[i].getLocations();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.splits.length);
        for (InputSplit s : this.splits) {
            Text.writeString(out, s.getClass().getName());
        }
        for (InputSplit s : this.splits) {
            s.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int card = WritableUtils.readVInt(in);
        if (this.splits == null || this.splits.length != card) {
            this.splits = new InputSplit[card];
        }
        Class[] cls = new Class[card];
        try {
            int i;
            for (i = 0; i < card; ++i) {
                cls[i] = Class.forName(Text.readString(in)).asSubclass(InputSplit.class);
            }
            for (i = 0; i < card; ++i) {
                this.splits[i] = (InputSplit)ReflectionUtils.newInstance(cls[i], null);
                this.splits[i].readFields(in);
            }
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("Failed split init").initCause(e);
        }
    }
}

