/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.server.compaction.BaseCandidateSearchPolicy;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.CompactionStatistics;
import org.apache.druid.server.compaction.CompactionTaskStatus;

public class MostFragmentedIntervalFirstPolicy
extends BaseCandidateSearchPolicy {
    private static final HumanReadableBytes SIZE_2_GB = new HumanReadableBytes("2GiB");
    private static final HumanReadableBytes SIZE_10_MB = new HumanReadableBytes("10MiB");
    private final int minUncompactedCount;
    private final HumanReadableBytes minUncompactedBytes;
    private final HumanReadableBytes maxAverageUncompactedBytesPerSegment;

    @JsonCreator
    public MostFragmentedIntervalFirstPolicy(@JsonProperty(value="minUncompactedCount") @Nullable Integer minUncompactedCount, @JsonProperty(value="minUncompactedBytes") @Nullable HumanReadableBytes minUncompactedBytes, @JsonProperty(value="maxAverageUncompactedBytesPerSegment") @Nullable HumanReadableBytes maxAverageUncompactedBytesPerSegment, @JsonProperty(value="priorityDatasource") @Nullable String priorityDatasource) {
        super(priorityDatasource);
        InvalidInput.conditionalException((minUncompactedCount == null || minUncompactedCount > 0 ? 1 : 0) != 0, (String)"'minUncompactedCount'[%s] must be greater than 0", (Object[])new Object[]{minUncompactedCount});
        InvalidInput.conditionalException((maxAverageUncompactedBytesPerSegment == null || maxAverageUncompactedBytesPerSegment.getBytes() > 0L ? 1 : 0) != 0, (String)"'minUncompactedCount'[%s] must be greater than 0", (Object[])new Object[]{maxAverageUncompactedBytesPerSegment});
        this.minUncompactedCount = Configs.valueOrDefault((Integer)minUncompactedCount, (int)100);
        this.minUncompactedBytes = (HumanReadableBytes)Configs.valueOrDefault((Object)minUncompactedBytes, (Object)SIZE_10_MB);
        this.maxAverageUncompactedBytesPerSegment = (HumanReadableBytes)Configs.valueOrDefault((Object)maxAverageUncompactedBytesPerSegment, (Object)SIZE_2_GB);
    }

    @JsonProperty
    public int getMinUncompactedCount() {
        return this.minUncompactedCount;
    }

    @JsonProperty
    public HumanReadableBytes getMinUncompactedBytes() {
        return this.minUncompactedBytes;
    }

    @JsonProperty
    public HumanReadableBytes getMaxAverageUncompactedBytesPerSegment() {
        return this.maxAverageUncompactedBytesPerSegment;
    }

    @Override
    protected Comparator<CompactionCandidate> getSegmentComparator() {
        return this::compare;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MostFragmentedIntervalFirstPolicy policy = (MostFragmentedIntervalFirstPolicy)o;
        return this.minUncompactedCount == policy.minUncompactedCount && Objects.equals(this.minUncompactedBytes, policy.minUncompactedBytes) && Objects.equals(this.maxAverageUncompactedBytesPerSegment, policy.maxAverageUncompactedBytesPerSegment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minUncompactedCount, this.minUncompactedBytes, this.maxAverageUncompactedBytesPerSegment);
    }

    public String toString() {
        return "MostFragmentedIntervalFirstPolicy{minUncompactedCount=" + this.minUncompactedCount + ", minUncompactedBytes=" + String.valueOf(this.minUncompactedBytes) + ", maxAverageUncompactedBytesPerSegment=" + String.valueOf(this.maxAverageUncompactedBytesPerSegment) + ", priorityDataSource='" + this.getPriorityDatasource() + "'}";
    }

    private int compare(CompactionCandidate candidateA, CompactionCandidate candidateB) {
        double fragmentationDiff = this.computeFragmentationIndex(candidateB) - this.computeFragmentationIndex(candidateA);
        return (int)fragmentationDiff;
    }

    @Override
    public CompactionCandidateSearchPolicy.Eligibility checkEligibilityForCompaction(CompactionCandidate candidate, CompactionTaskStatus latestTaskStatus) {
        CompactionStatistics uncompacted = candidate.getUncompactedStats();
        if (uncompacted == null) {
            return CompactionCandidateSearchPolicy.Eligibility.OK;
        }
        if (uncompacted.getNumSegments() < 1L) {
            return CompactionCandidateSearchPolicy.Eligibility.fail("No uncompacted segments in interval", new Object[0]);
        }
        if (uncompacted.getNumSegments() < (long)this.minUncompactedCount) {
            return CompactionCandidateSearchPolicy.Eligibility.fail("Uncompacted segments[%,d] in interval must be at least [%,d]", uncompacted.getNumSegments(), this.minUncompactedCount);
        }
        if (uncompacted.getTotalBytes() < this.minUncompactedBytes.getBytes()) {
            return CompactionCandidateSearchPolicy.Eligibility.fail("Uncompacted bytes[%,d] in interval must be at least [%,d]", uncompacted.getTotalBytes(), this.minUncompactedBytes.getBytes());
        }
        long avgSegmentSize = uncompacted.getTotalBytes() / uncompacted.getNumSegments();
        if (avgSegmentSize > this.maxAverageUncompactedBytesPerSegment.getBytes()) {
            return CompactionCandidateSearchPolicy.Eligibility.fail("Average size[%,d] of uncompacted segments in interval must be at most [%,d]", avgSegmentSize, this.maxAverageUncompactedBytesPerSegment.getBytes());
        }
        return CompactionCandidateSearchPolicy.Eligibility.OK;
    }

    private double computeFragmentationIndex(CompactionCandidate candidate) {
        CompactionStatistics uncompacted = candidate.getUncompactedStats();
        if (uncompacted == null || uncompacted.getNumSegments() < 1L || uncompacted.getTotalBytes() < 1L) {
            return 0.0;
        }
        long avgUncompactedSize = Math.max(1L, uncompacted.getTotalBytes() / uncompacted.getNumSegments());
        double segmentCountTerm = uncompacted.getNumSegments();
        double segmentSizeTerm = 1.0f * (float)this.minUncompactedCount * (float)this.maxAverageUncompactedBytesPerSegment.getBytes() / (float)avgUncompactedSize;
        return segmentCountTerm + segmentSizeTerm;
    }
}

