/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.audit;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.error.DruidException;
import org.apache.druid.server.audit.AuditLogger;
import org.apache.druid.server.audit.AuditManagerConfig;
import org.apache.druid.server.audit.AuditSerdeHelper;
import org.apache.druid.server.audit.LoggingAuditManagerConfig;
import org.joda.time.Interval;

public class LoggingAuditManager
implements AuditManager {
    private final AuditLogger auditLogger;
    private final LoggingAuditManagerConfig managerConfig;
    private final AuditSerdeHelper serdeHelper;

    @Inject
    public LoggingAuditManager(AuditManagerConfig config, AuditSerdeHelper serdeHelper) {
        if (!(config instanceof LoggingAuditManagerConfig)) {
            throw DruidException.defensive((String)"Config[%s] is not an instance of LoggingAuditManagerConfig", (Object[])new Object[]{config});
        }
        this.managerConfig = (LoggingAuditManagerConfig)config;
        this.serdeHelper = serdeHelper;
        this.auditLogger = new AuditLogger(this.managerConfig.getLogLevel());
    }

    public void doAudit(AuditEntry entry) {
        if (this.serdeHelper.shouldProcessAuditEntry(entry)) {
            this.auditLogger.log(this.serdeHelper.processAuditEntry(entry));
        }
    }

    public List<AuditEntry> fetchAuditHistory(String key, String type, Interval interval) {
        return Collections.emptyList();
    }

    public List<AuditEntry> fetchAuditHistory(String type, Interval interval) {
        return Collections.emptyList();
    }

    public List<AuditEntry> fetchAuditHistory(String key, String type, int limit) {
        return Collections.emptyList();
    }

    public List<AuditEntry> fetchAuditHistory(String type, int limit) {
        return Collections.emptyList();
    }

    public int removeAuditLogsOlderThan(long timestamp) {
        return 0;
    }
}

