/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.segment.column.RowSignature;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SamplerResponse {
    private final int numRowsRead;
    private final int numRowsIndexed;
    private final List<DimensionSchema> logicalDimensions;
    private final List<DimensionSchema> physicalDimensions;
    private final RowSignature logicalSegmentSchema;
    private final List<SamplerResponseRow> data;

    @JsonCreator
    public SamplerResponse(@JsonProperty(value="numRowsRead") int numRowsRead, @JsonProperty(value="numRowsIndexed") int numRowsIndexed, @JsonProperty(value="logicalDimensions") List<DimensionSchema> logicalDimensions, @JsonProperty(value="physicalDimensions") List<DimensionSchema> physicalDimensions, @JsonProperty(value="logicalSegmentSchema") RowSignature logicalSegmentSchema, @JsonProperty(value="data") List<SamplerResponseRow> data) {
        this.numRowsRead = numRowsRead;
        this.numRowsIndexed = numRowsIndexed;
        this.logicalDimensions = logicalDimensions;
        this.physicalDimensions = physicalDimensions;
        this.logicalSegmentSchema = logicalSegmentSchema;
        this.data = data;
    }

    @JsonProperty
    public int getNumRowsRead() {
        return this.numRowsRead;
    }

    @JsonProperty
    public int getNumRowsIndexed() {
        return this.numRowsIndexed;
    }

    @JsonProperty
    public List<DimensionSchema> getLogicalDimensions() {
        return this.logicalDimensions;
    }

    @JsonProperty
    public List<DimensionSchema> getPhysicalDimensions() {
        return this.physicalDimensions;
    }

    @JsonProperty
    public RowSignature getLogicalSegmentSchema() {
        return this.logicalSegmentSchema;
    }

    @JsonProperty
    public List<SamplerResponseRow> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamplerResponse that = (SamplerResponse)o;
        return this.getNumRowsRead() == that.getNumRowsRead() && this.getNumRowsIndexed() == that.getNumRowsIndexed() && Objects.equals(this.logicalDimensions, that.logicalDimensions) && Objects.equals(this.physicalDimensions, that.physicalDimensions) && Objects.equals(this.logicalSegmentSchema, that.logicalSegmentSchema) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.getNumRowsRead(), this.getNumRowsIndexed(), this.logicalDimensions, this.physicalDimensions, this.logicalSegmentSchema, this.data);
    }

    public String toString() {
        return "SamplerResponse{numRowsRead=" + this.numRowsRead + ", numRowsIndexed=" + this.numRowsIndexed + ", logicalDimensions=" + String.valueOf(this.logicalDimensions) + ", physicalDimensions=" + String.valueOf(this.physicalDimensions) + ", logicalSegmentSchema=" + String.valueOf(this.logicalSegmentSchema) + ", data=" + String.valueOf(this.data) + "}";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class SamplerResponseRow {
        private final Map<String, Object> input;
        private final Map<String, Object> parsed;
        private final Boolean unparseable;
        private final String error;

        @JsonCreator
        public SamplerResponseRow(@JsonProperty(value="input") Map<String, Object> input, @JsonProperty(value="parsed") Map<String, Object> parsed, @JsonProperty(value="unparseable") Boolean unparseable, @JsonProperty(value="error") String error) {
            this.input = input;
            this.parsed = parsed;
            this.unparseable = unparseable;
            this.error = error;
        }

        @JsonProperty
        public Map<String, Object> getInput() {
            return this.input;
        }

        @JsonProperty
        public Map<String, Object> getParsed() {
            return this.parsed;
        }

        @JsonProperty
        public Boolean isUnparseable() {
            return this.unparseable;
        }

        @JsonProperty
        public String getError() {
            return this.error;
        }

        public SamplerResponseRow withParsed(Map<String, Object> parsed) {
            return new SamplerResponseRow(this.input, parsed, this.unparseable, this.error);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SamplerResponseRow that = (SamplerResponseRow)o;
            return Objects.equals(this.input, that.input) && Objects.equals(this.parsed, that.parsed) && Objects.equals(this.unparseable, that.unparseable) && Objects.equals(this.error, that.error);
        }

        public int hashCode() {
            return Objects.hash(this.input, this.parsed, this.unparseable, this.error);
        }

        public String toString() {
            return "SamplerResponseRow{rawInput=" + String.valueOf(this.input) + ", parsed=" + String.valueOf(this.parsed) + ", unparseable=" + this.unparseable + ", error='" + this.error + "'}";
        }
    }
}

