/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.dpath;

import org.apache.daffodil.lib.exceptions.SchemaFileLocation;
import org.apache.daffodil.runtime1.dpath.CompiledDPath;
import org.apache.daffodil.runtime1.dpath.DFDLTestBit$;
import org.apache.daffodil.runtime1.dpath.DState;
import org.apache.daffodil.runtime1.dpath.RecipeOpWithSubRecipes;
import org.apache.daffodil.runtime1.dsom.SchemaDefinitionError;
import org.apache.daffodil.runtime1.infoset.DINode;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public class DFDLTestBit
extends RecipeOpWithSubRecipes
implements Product {
    private final CompiledDPath dataRecipe;
    private final CompiledDPath bitPos1bRecipe;

    public static DFDLTestBit apply(CompiledDPath compiledDPath, CompiledDPath compiledDPath2) {
        return DFDLTestBit$.MODULE$.apply(compiledDPath, compiledDPath2);
    }

    public static DFDLTestBit fromProduct(Product product) {
        return DFDLTestBit$.MODULE$.fromProduct(product);
    }

    public static DFDLTestBit unapply(DFDLTestBit dFDLTestBit) {
        return DFDLTestBit$.MODULE$.unapply(dFDLTestBit);
    }

    public DFDLTestBit(CompiledDPath dataRecipe, CompiledDPath bitPos1bRecipe) {
        this.dataRecipe = dataRecipe;
        this.bitPos1bRecipe = bitPos1bRecipe;
        super((Seq<CompiledDPath>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CompiledDPath[]{dataRecipe, bitPos1bRecipe}));
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -1425156594, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DFDLTestBit)) return false;
        DFDLTestBit dFDLTestBit = (DFDLTestBit)object;
        CompiledDPath compiledDPath = this.dataRecipe();
        CompiledDPath compiledDPath2 = dFDLTestBit.dataRecipe();
        if (compiledDPath == null) {
            if (compiledDPath2 != null) {
                return false;
            }
        } else if (!compiledDPath.equals(compiledDPath2)) return false;
        CompiledDPath compiledDPath3 = this.bitPos1bRecipe();
        CompiledDPath compiledDPath4 = dFDLTestBit.bitPos1bRecipe();
        if (compiledDPath3 == null) {
            if (compiledDPath4 != null) {
                return false;
            }
        } else if (!compiledDPath3.equals(compiledDPath4)) return false;
        if (!dFDLTestBit.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DFDLTestBit;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "DFDLTestBit";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "dataRecipe";
        }
        if (1 == n2) {
            return "bitPos1bRecipe";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public CompiledDPath dataRecipe() {
        return this.dataRecipe;
    }

    public CompiledDPath bitPos1bRecipe() {
        return this.bitPos1bRecipe;
    }

    @Override
    public void run(DState dstate) {
        DINode saved = dstate.currentNode();
        this.dataRecipe().run(dstate);
        int dataVal = dstate.intValue();
        dstate.setCurrentNode(saved);
        this.bitPos1bRecipe().run(dstate);
        int bitPos1b = dstate.intValue();
        this.checkRange(bitPos1b);
        boolean res = this.testBit(dataVal, bitPos1b);
        dstate.setCurrentValue(res);
    }

    private void checkRange(int i) {
        if (i > 8 || i < 1) {
            throw new SchemaDefinitionError((Option<SchemaFileLocation>)None$.MODULE$, (Option<SchemaFileLocation>)None$.MODULE$, "dfdl:testBit $bitPos must be between 1 and 8 (inclusive). Was %s.", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
        }
    }

    private boolean testBit(int data, int bitPos1b) {
        int shifted = data >>> bitPos1b - 1;
        int maskedVal = shifted & 1;
        return maskedVal == 1;
    }

    public DFDLTestBit copy(CompiledDPath dataRecipe, CompiledDPath bitPos1bRecipe) {
        return new DFDLTestBit(dataRecipe, bitPos1bRecipe);
    }

    public CompiledDPath copy$default$1() {
        return this.dataRecipe();
    }

    public CompiledDPath copy$default$2() {
        return this.bitPos1bRecipe();
    }

    public CompiledDPath _1() {
        return this.dataRecipe();
    }

    public CompiledDPath _2() {
        return this.bitPos1bRecipe();
    }
}

