/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler;

import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.request.JolokiaListRequest;
import org.jolokia.server.core.request.JolokiaRequest;
import org.jolokia.server.core.request.NotChangedException;
import org.jolokia.server.core.util.EscapeUtil;
import org.jolokia.server.core.util.ProviderUtil;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.service.jmx.handler.AbstractCommandHandler;
import org.jolokia.service.jmx.handler.ListMBeanEachAction;

public class ListHandler
extends AbstractCommandHandler<JolokiaListRequest> {
    @Override
    public RequestType getType() {
        return RequestType.LIST;
    }

    @Override
    public boolean handleAllServersAtOnce(JolokiaListRequest pRequest) {
        return true;
    }

    @Override
    protected void checkForRestriction(JolokiaListRequest pRequest) {
        this.checkType();
    }

    @Override
    public Object doHandleAllServerRequest(MBeanServerAccess pServerManager, JolokiaListRequest pRequest, Object pPreviousResult) throws IOException, NotChangedException {
        this.checkForModifiedSince(pServerManager, (JolokiaRequest)pRequest);
        Deque originalPathStack = EscapeUtil.reversePath((List)pRequest.getPathParts());
        int maxDepth = pRequest.getParameterAsInt(ConfigKey.MAX_DEPTH);
        boolean useCanonicalName = pRequest.getParameterAsBool(ConfigKey.CANONICAL_NAMING);
        boolean listKeys = pRequest.getParameterAsBool(ConfigKey.LIST_KEYS);
        boolean listCache = pRequest.getParameterAsBool(ConfigKey.LIST_CACHE);
        ObjectName oName = null;
        try {
            LinkedList<String> pathStack = new LinkedList<String>(originalPathStack);
            oName = this.objectNameFromPath(pathStack);
            if (oName != null) {
                if (ProviderUtil.matchesProvider((String)this.pProvider, (ObjectName)oName)) {
                    oName = ProviderUtil.extractProvider((ObjectName)oName).getObjectName();
                } else {
                    return pPreviousResult != null ? pPreviousResult : new JSONObject();
                }
            }
            ListMBeanEachAction action = new ListMBeanEachAction(maxDepth, pathStack, useCanonicalName, listKeys, listCache, this.pProvider, this.context);
            return this.executeListAction(pServerManager, (Map)pPreviousResult, oName, action);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid path within the MBean part given. (Path: " + pRequest.getPath() + ")", e);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalArgumentException("No MBean '" + String.valueOf(oName) + "' found", e);
        }
        catch (JMException e) {
            throw new IllegalStateException("Internal error while retrieving list: " + String.valueOf(e), e);
        }
    }

    private Object executeListAction(MBeanServerAccess pServerManager, Map<?, ?> pPreviousResult, ObjectName pName, ListMBeanEachAction pAction) throws IOException, ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
        if (pName == null || pName.isPattern()) {
            pServerManager.each(pName, (MBeanServerAccess.MBeanEachCallback)pAction);
        } else {
            pServerManager.call(pName, (MBeanServerAccess.MBeanAction)pAction, new Object[0]);
        }
        return pAction.getResult(pPreviousResult);
    }

    @Override
    public Object doHandleSingleServerRequest(MBeanServerConnection server, JolokiaListRequest request) {
        throw new UnsupportedOperationException("Internal: Method must not be called when all MBeanServers are handled at once");
    }

    private ObjectName objectNameFromPath(Deque<String> pPathStack) throws MalformedObjectNameException {
        if (pPathStack.isEmpty()) {
            return null;
        }
        LinkedList<String> path = new LinkedList<String>(pPathStack);
        String domain = (String)path.pop();
        if (path.isEmpty()) {
            return new ObjectName(domain + ":*");
        }
        String props = (String)path.pop();
        ObjectName mbean = new ObjectName(domain + ":" + props);
        if (mbean.isPattern()) {
            throw new IllegalArgumentException("Cannot use an MBean pattern as path (given MBean: " + String.valueOf(mbean) + ")");
        }
        return mbean;
    }
}

