/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.OutputExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="loop")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LoopDefinition
extends OutputExpressionNode {
    @XmlTransient
    private Processor onPrepareProcessor;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String copy;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String doWhile;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String breakOnShutdown;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.Processor")
    private String onPrepare;

    public LoopDefinition() {
    }

    protected LoopDefinition(LoopDefinition source) {
        super(source);
        this.copy = source.copy;
        this.doWhile = source.doWhile;
        this.breakOnShutdown = source.breakOnShutdown;
        this.onPrepareProcessor = source.onPrepareProcessor;
        this.onPrepare = source.onPrepare;
    }

    public LoopDefinition(Expression expression) {
        super(expression);
    }

    public LoopDefinition(Predicate predicate) {
        super(predicate);
        this.setDoWhile(Boolean.toString(true));
    }

    public LoopDefinition(ExpressionDefinition expression) {
        super(expression);
    }

    @Override
    public LoopDefinition copyDefinition() {
        return new LoopDefinition(this);
    }

    public Processor getOnPrepareProcessor() {
        return this.onPrepareProcessor;
    }

    public LoopDefinition copy() {
        this.setCopy(Boolean.toString(true));
        return this;
    }

    public LoopDefinition onPrepare(Processor onPrepare) {
        this.onPrepareProcessor = onPrepare;
        return this;
    }

    public LoopDefinition onPrepare(String onPrepare) {
        this.setOnPrepare(onPrepare);
        return this;
    }

    public String getCopy() {
        return this.copy;
    }

    public String getDoWhile() {
        return this.doWhile;
    }

    public void setDoWhile(String doWhile) {
        this.doWhile = doWhile;
    }

    public void setCopy(String copy) {
        this.copy = copy;
    }

    public LoopDefinition breakOnShutdown() {
        this.setBreakOnShutdown(Boolean.toString(true));
        return this;
    }

    public void setBreakOnShutdown(String breakOnShutdown) {
        this.breakOnShutdown = breakOnShutdown;
    }

    public String getBreakOnShutdown() {
        return this.breakOnShutdown;
    }

    public String getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(String onPrepare) {
        this.onPrepare = onPrepare;
    }

    public String toString() {
        return "Loop[" + String.valueOf(this.getExpression()) + " -> " + String.valueOf(this.getOutputs()) + "]";
    }

    public String getShortName() {
        return "loop";
    }

    @Override
    public String getLabel() {
        return "loop[" + String.valueOf(this.getExpression()) + "]";
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }
}

