/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.AttributeNotFoundException;
import org.jolokia.json.JSONArray;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.service.serializer.json.ObjectAccessor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.Converter;

public class ListAccessor
implements ObjectAccessor {
    @Override
    public Class<?> getType() {
        return List.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pList, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        String pathPart;
        List list = (List)pList;
        int length = pConverter.getCollectionLength(list.size());
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            return this.extractListItem(pConverter, list, pPathParts, pJsonify, pathPart);
        }
        return pJsonify ? this.listToJSON(pConverter, list, pPathParts, length) : list;
    }

    @Override
    public boolean canSetValue() {
        return true;
    }

    @Override
    public Object setObjectValue(Converter<String> pConverter, Object pList, String pIndex, Object pValue) throws IllegalAccessException, InvocationTargetException {
        int idx;
        if (!(pList instanceof List)) {
            throw new IllegalArgumentException("ListAccessor can't access objects of type " + String.valueOf(pList.getClass()));
        }
        List list = (List)pList;
        try {
            idx = Integer.parseInt(pIndex);
        }
        catch (NumberFormatException exp) {
            throw new IllegalArgumentException("Non-numeric index for accessing list " + String.valueOf(pList) + ". (index = " + pIndex + ", value to set = " + String.valueOf(pValue) + ")", exp);
        }
        Object oldValue = list.get(idx);
        Object newValue = pValue;
        if (oldValue != null) {
            newValue = pConverter.convert(oldValue.getClass().getName(), pValue);
        }
        list.set(idx, newValue);
        return oldValue;
    }

    private Object listToJSON(ObjectToJsonConverter pConverter, List<?> pList, Deque<String> pPath, int pLength) throws AttributeNotFoundException {
        JSONArray ret = new JSONArray(pLength);
        Iterator<?> it = pList.iterator();
        for (int idx = 0; it.hasNext() && idx < pLength; ++idx) {
            Object item = it.next();
            LinkedList<String> path = new LinkedList<String>(pPath);
            try {
                ret.add(pConverter.extractObject(item, path, true));
                continue;
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {
                // empty catch block
            }
        }
        if (ret.isEmpty() && pLength > 0) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    private Object extractListItem(ObjectToJsonConverter pConverter, List<?> pList, Deque<String> pPath, boolean pJsonify, String pPathPart) throws AttributeNotFoundException {
        try {
            int idx = Integer.parseInt(pPathPart);
            return pConverter.extractObject(pList.get(idx), pPath, pJsonify);
        }
        catch (NumberFormatException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException((Throwable)new AttributeNotFoundException("Index '" + pPathPart + "' is not a numeric for accessing a list"));
        }
        catch (IndexOutOfBoundsException exp) {
            ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
            return faultHandler.handleException((Throwable)new AttributeNotFoundException("Index '" + pPathPart + "' is out-of-bound for a list of size " + pList.size()));
        }
    }
}

