/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashSet;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Service;
import org.apache.camel.support.AbstractVariableRepository;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.camel.util.StringHelper;

final class ExchangeVariableRepository
extends AbstractVariableRepository {
    public ExchangeVariableRepository(CamelContext camelContext) {
        this.setCamelContext(camelContext);
        ServiceHelper.startService((Service)this);
    }

    void copyFrom(ExchangeVariableRepository source) {
        this.setVariables(source.getVariables());
    }

    @Override
    public Object getVariable(String name) {
        String id = StringHelper.before((String)name, (String)":");
        if ("header".equals(id)) {
            Object prefix = StringHelper.after((String)name, (String)":");
            if (prefix == null || ((String)prefix).isBlank()) {
                throw new IllegalArgumentException("Variable " + name + " must have header key");
            }
            if (!((String)prefix).contains(".")) {
                prefix = (String)prefix + ".";
                CaseInsensitiveMap map = new CaseInsensitiveMap();
                for (Map.Entry<String, Object> entry : this.getVariables().entrySet()) {
                    String key = entry.getKey();
                    if (!key.startsWith(name + ".")) continue;
                    key = StringHelper.after((String)key, (String)prefix);
                    map.put(key, entry.getValue());
                }
                return map;
            }
        }
        return super.getVariable(name);
    }

    @Override
    public Object removeVariable(String name) {
        String id = StringHelper.before((String)name, (String)":");
        if ("header".equals(id)) {
            String prefix = StringHelper.after((String)name, (String)":");
            if (prefix == null || prefix.isBlank()) {
                throw new IllegalArgumentException("Variable " + name + " must have header key");
            }
            if (!prefix.contains(".")) {
                HashSet<String> toRemove = new HashSet<String>();
                for (Map.Entry<String, Object> entry : this.getVariables().entrySet()) {
                    String key = entry.getKey();
                    if (!key.startsWith(name + ".")) continue;
                    toRemove.add(key);
                }
                toRemove.forEach(x$0 -> super.removeVariable((String)x$0));
                return null;
            }
        }
        return super.removeVariable(name);
    }

    public String getId() {
        return "exchange";
    }
}

