% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_fill_depressions_planchon_and_darboux}
\alias{wbt_fill_depressions_planchon_and_darboux}
\title{Fill depressions planchon and darboux}
\usage{
wbt_fill_depressions_planchon_and_darboux(
  dem,
  output,
  fix_flats = TRUE,
  flat_increment = NULL,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output raster file.}

\item{fix_flats}{Optional flag indicating whether flat areas should have a small gradient applied.}

\item{flat_increment}{Optional elevation increment applied to flat areas.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Fills all of the depressions in a DEM using the Planchon and Darboux (2002) method.
}
\keyword{HydrologicalAnalysis}
