% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runtoxdrc.R
\name{runtoxdrc}
\alias{runtoxdrc}
\title{Point estmation pipeline}
\usage{
runtoxdrc(
  dataset,
  Conc,
  Response,
  IDcols = NULL,
  quiet = FALSE,
  qc = toxdrc_qc(),
  normalization = toxdrc_normalization(),
  toxicity = toxdrc_toxicity(),
  modelling = toxdrc_modelling(),
  output = toxdrc_output()
)
}
\arguments{
\item{dataset}{A dataframe, containing the columns `Conc` and `Response`.}

\item{Conc}{Bare (unquoted) column name in `dataset` that groups the
`Response` variable.}

\item{Response}{Bare (unquoted) column name in `dataset` containing
the response variable.}

\item{IDcols}{Optional. Character. Columns given as a vector used in the
identification of data. These columns are preserved in the modified
`dataset` with the first non-blank value. These values should be
identical within observations grouped by `Conc`.}

\item{quiet}{Logical. Indicates if results should be hidden. Defaults
to FALSE.}

\item{qc}{Quality control and filtering options. See [toxdrc_qc()]
for more detail and defaults.}

\item{normalization}{Normalization options. See [toxdrc_normalization()]
for more detail and defaults.}

\item{toxicity}{Toxicity threshold and response-level options. See
[toxdrc_toxicity()] for more detail and defaults.}

\item{modelling}{Model selection, fitting criteria, and EDx calculation
options. See [toxdrc_modelling()] for more detail and defaults.}

\item{output}{Settings for output. See [toxdrc_output()] for more detail
and defaults.}
}
\value{
By default, returns a list of lists with each subset of data having
 its own entry. Each subset contains dataframes, models, and other objects
 that track the pipeline process. If `output = list(condense = TRUE)`, the
 results are summarized into a single dataframe containing the `IDcols` and
 model information of each data subset.
}
\description{
`runtoxdrc()` is the pipeline for function in the toxdrc package. This
 function allows the automated analysis of large datasets, while
 maintaining a consistent process for each suset of data.
}
\examples{
\donttest{
  analyzed_data <- runtoxdrc(
 dataset = cellglow,
 Conc = Conc,
 Response = RFU,
 IDcols = c("Test_Number", "Dye", "Replicate", "Type"),
 quiet = TRUE,
 normalization = toxdrc_normalization(
   blank.correction = TRUE,
   normalize.resp = TRUE
 ),
 modelling = toxdrc_modelling(EDx = c(0.2, 0.5, 0.7))
)
}

}
\seealso{
[config_runtoxdrc()] for configuration settings of the pipeline.
}
