% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_xmile.R
\name{debugger}
\alias{debugger}
\title{Debug stock-and-flow model}
\usage{
debugger(sfm, quietly = FALSE)
}
\arguments{
\item{sfm}{Stock-and-flow model, object of class \code{\link[=xmile]{sdbuildR_xmile}}.}

\item{quietly}{If TRUE, don't print problems. Defaults to FALSE.}
}
\value{
If \code{quietly = FALSE}, list with problems and potential problems.
}
\description{
Check for common formulation problems in a stock-and-flow model.
}
\details{
The following problems are detected:
\itemize{
\item An absence of stocks
\item Flows without a source (\code{from}) or target (\code{to})
\item Flows connected to a stock that does not exist
\item Undefined variable references in equations
\item Circularity in equations
\item Connected stocks and flows without both having units or no units
\item Missing unit definitions
}

The following potential problems are detected:
\itemize{
\item Absence of flows
\item Stocks without inflows or outflows
\item Equations with a value of 0
}
}
\examples{
# No issues
sfm <- xmile("SIR")
debugger(sfm)

# Detect absence of stocks or flows
sfm <- xmile()
debugger(sfm)

# Detect stocks without inflows or outflows
sfm <- xmile() |> build("Prey", "stock")
debugger(sfm)

# Detect circularity in equation definitions
sfm <- xmile() |>
  build("Prey", "stock", eqn = "Predator") |>
  build("Predator", "stock", eqn = "Prey")
debugger(sfm)

}
\concept{build}
