% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCA_Server.R
\name{mk_table_nca_params}
\alias{mk_table_nca_params}
\title{Create Tabular Output from PKNCA Results}
\usage{
mk_table_nca_params(
  nca_res,
  type = "individual",
  grouping = "interval",
  not_calc = "NC",
  obnd = NULL,
  nps = NULL,
  mult_str = "*",
  infinity = "inf",
  digits = NULL,
  text_format = "text",
  notes_detect = NULL,
  max_height = 7,
  max_width = 6.5,
  max_row = NULL,
  max_col = NULL
)
}
\arguments{
\item{nca_res}{Output of PKNCA.}

\item{type}{Type of table to generate. Can be either \code{"individual"} or \code{"summary"]}.}

\item{grouping}{How to group columns in tables. Can be either \code{"interval"} or \code{"parameter"]}.}

\item{not_calc}{Text string to replace NA values with to indicated values were not calculated.}

\item{obnd}{onbrand reporting object.}

\item{nps}{NCA parameter summary table with the following columns.
\itemize{
\item{parameter:}      PKNCA Paramter name.
\item{text:}           Name used in text output.
\item{md:}             Name used markdown output.
\item{latex:}          Name used in latex output.
\item{description:}    Verbose textual description of the parameter.
}}

\item{mult_str}{Text string to replace * values in units.}

\item{infinity}{Text string to replace infinity in time intervals in column headers.}

\item{digits}{Number of significant figures to report (set to \code{NULL} to disable rounding)}

\item{text_format}{Either \code{"md"} for markdown or \code{"text"} (default) for plain text.}

\item{notes_detect}{Vector of strings to detect in output tables (example \code{c("NC", "BLQ")}).}

\item{max_height}{Maximum height of the final table in inches (A value of \code{NULL} will use 100 inches).}

\item{max_width}{Maximum width of the final table in inches (A value of \code{NULL} will use 100 inches).}

\item{max_row}{Maximum number of rows to have on a page. Spillover will hang over the side of the page..}

\item{max_col}{Maximum number of columns to have on a page. Spillover will be wrapped to multiple pages.}
}
\value{
list containing the following elements
\itemize{
\item{raw_nca:}     Raw PKNCA output.
\item{isgood:}      Boolean indicating the exit status of the function.
\item{one_table:}   Dataframe of the entire table with the first lines containing the header.
\item{one_body:}    Dataframe of the entire table (data only).
\item{one_header:}  Dataframe of the entire header (row and body, no data).
\item{tables:}      Named list of tables. Each list element is of the output
\item{msgs:}        Vector of text messages describing any errors that were found.
format from \code{\link[onbrand]{build_span}}.
}
}
\description{
Create paginated tables from PKNCA to use in reports and Shiny
apps.
}
\examples{
# We need a state variable to be define
sess_res = NCA_test_mksession()

state = sess_res$state

# Pulls out the active analysis
current_ana = NCA_fetch_current_ana(state)

# This is the raw PKNCA output
pknca_res = NCA_fetch_ana_pknca(state, current_ana)

# Parameter reporting details from the ruminate configuration
nps  = state[["NCA"]][["nca_parameters"]][["summary"]]

# Building the figure
mk_res = mk_table_nca_params(nca_res = pknca_res, nps=nps, digits=3)
mk_res$tables[["Table 1"]]$ft
}
