% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KrigingClass.R
\name{save.Kriging}
\alias{save.Kriging}
\alias{save,Kriging,Kriging-method}
\title{Save a Kriging Model to a file storage}
\usage{
\method{save}{Kriging}(object, filename, ...)
}
\arguments{
\item{object}{An S3 Kriging object.}

\item{filename}{File name to save in.}

\item{...}{Not used.}
}
\value{
The loaded Kriging object.
}
\description{
Save a Kriging Model to a file storage
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- Kriging(y, X, kernel = "matern3_2", objective="LMP")
print(k)

outfile = tempfile("k.json") 
save(k,outfile)
}
\author{
Yann Richet \email{yann.richet@asnr.fr}
}
