/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.processing.DiagnosticsConfiguration;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SpectralDiagnosticsConfiguration
implements DiagnosticsConfiguration {
    private static final AtomicReference<SpectralDiagnosticsConfiguration> DEFAULT = new AtomicReference<SpectralDiagnosticsConfiguration>(SpectralDiagnosticsConfiguration.builder().build());
    public static final boolean ACTIVE = false;
    public static final boolean STRICT = false;
    public static final double SENSIBILITY = 0.11538461538461539;
    public static final int LENGTH = 8;
    private final double sensibility;
    private final int length;
    private final boolean strict;
    private final boolean active;

    public static void setDefault(SpectralDiagnosticsConfiguration config) {
        DEFAULT.set(config);
    }

    public static SpectralDiagnosticsConfiguration getDefault() {
        return DEFAULT.get();
    }

    public static Builder builder() {
        return new Builder().sensibility(0.11538461538461539).length(8).strict(false).active(false);
    }

    public void check() {
        if (this.sensibility < 0.057692307692307696) {
            throw new IllegalArgumentException("Value is too low (should be grater than 3/52)");
        }
        if (this.length != 0 && this.length < 6) {
            throw new IllegalArgumentException("Value is too low (should be 0 or greater than 5)");
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public DiagnosticsConfiguration activate(boolean active) {
        if (this.active == active) {
            return this;
        }
        return this.toBuilder().active(active).build();
    }

    @Generated
    SpectralDiagnosticsConfiguration(double sensibility, int length, boolean strict, boolean active) {
        this.sensibility = sensibility;
        this.length = length;
        this.strict = strict;
        this.active = active;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().sensibility(this.sensibility).length(this.length).strict(this.strict).active(this.active);
    }

    @Generated
    public double getSensibility() {
        return this.sensibility;
    }

    @Generated
    public int getLength() {
        return this.length;
    }

    @Generated
    public boolean isStrict() {
        return this.strict;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpectralDiagnosticsConfiguration)) {
            return false;
        }
        SpectralDiagnosticsConfiguration other = (SpectralDiagnosticsConfiguration)o;
        if (Double.compare(this.getSensibility(), other.getSensibility()) != 0) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.isStrict() != other.isStrict()) {
            return false;
        }
        return this.isActive() == other.isActive();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sensibility = Double.doubleToLongBits(this.getSensibility());
        result = result * 59 + (int)($sensibility >>> 32 ^ $sensibility);
        result = result * 59 + this.getLength();
        result = result * 59 + (this.isStrict() ? 79 : 97);
        result = result * 59 + (this.isActive() ? 79 : 97);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "SpectralDiagnosticsConfiguration(sensibility=" + this.getSensibility() + ", length=" + this.getLength() + ", strict=" + this.isStrict() + ", active=" + this.isActive() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private double sensibility;
        @Generated
        private int length;
        @Generated
        private boolean strict;
        @Generated
        private boolean active;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder sensibility(double sensibility) {
            this.sensibility = sensibility;
            return this;
        }

        @Generated
        public @NonNull Builder length(int length) {
            this.length = length;
            return this;
        }

        @Generated
        public @NonNull Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        @Generated
        public @NonNull Builder active(boolean active) {
            this.active = active;
            return this;
        }

        @Generated
        public @NonNull SpectralDiagnosticsConfiguration build() {
            return new SpectralDiagnosticsConfiguration(this.sensibility, this.length, this.strict, this.active);
        }

        @Generated
        public @NonNull String toString() {
            return "SpectralDiagnosticsConfiguration.Builder(sensibility=" + this.sensibility + ", length=" + this.length + ", strict=" + this.strict + ", active=" + this.active + ")";
        }
    }
}

