/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.arima;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import lombok.Generated;

public final class Rw {
    public static StateComponent DEFAULT = Rw.of(1.0, false);

    public static StateComponent of(double var, boolean zeroinit) {
        Data data = new Data(var, zeroinit);
        return new StateComponent(new Initialization(data), new Dynamics(data));
    }

    public static ISsfLoading defaultLoading() {
        return Loading.fromPosition(0);
    }

    @Generated
    private Rw() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Data {
        final boolean zeroinit;
        final double var;

        Data(double var, boolean zeroinit) {
            this.var = var;
            this.zeroinit = zeroinit;
        }

        double std() {
            return this.var == 1.0 ? 1.0 : Math.sqrt(this.var);
        }
    }

    static class Initialization
    implements ISsfInitialization {
        private final Data data;

        Initialization(Data data) {
            this.data = data;
        }

        @Override
        public int getStateDim() {
            return 1;
        }

        @Override
        public boolean isDiffuse() {
            return !this.data.zeroinit;
        }

        @Override
        public int getDiffuseDim() {
            return this.data.zeroinit ? 0 : 1;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            if (!this.data.zeroinit) {
                b.set(1.0);
            }
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pf0(FastMatrix pf0) {
            if (this.data.zeroinit) {
                pf0.set(0, 0, this.data.var);
            }
        }

        @Override
        public void Pi0(FastMatrix pi0) {
            if (!this.data.zeroinit) {
                pi0.set(0, 0, 1.0);
            }
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final Data data;

        public Dynamics(Data data) {
            this.data = data;
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }

        @Override
        public int getInnovationsDim() {
            return 1;
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            qm.set(0, 0, this.data.var);
        }

        @Override
        public boolean hasInnovations(int pos) {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public void S(int pos, FastMatrix sm) {
            sm.set(0, 0, this.data.std());
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            x.add(0, this.data.std() * u.get(0));
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            xs.set(0, this.data.std() * x.get(0));
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            tr.set(0, 0, 1.0);
        }

        @Override
        public void TX(int pos, DataBlock x) {
        }

        @Override
        public void TVT(int pos, FastMatrix v) {
        }

        @Override
        public void XT(int pos, DataBlock x) {
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.add(0, 0, this.data.var);
        }
    }
}

