/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.StationaryTransformation;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import lombok.NonNull;

public final class RegArimaModel<M extends IArimaModel> {
    private final DoubleSeq y;
    private final M arima;
    private final boolean mean;
    private final List<DoubleSeq> x;
    private final int[] missing;
    private volatile RegArmaModel<M> dmodel;
    private static final int[] NOMISSING = new int[0];

    public static <M extends IArimaModel> Builder<M> builder() {
        return new Builder();
    }

    public static <M extends IArimaModel> RegArimaModel of(RegArimaModel<M> oldModel, M newArima) {
        RegArmaModel<Object> dm = oldModel.dmodel;
        if (dm != null) {
            StationaryTransformation st = newArima.stationaryTransformation();
            dm = st.getUnitRoots().equals(oldModel.arima.getNonStationaryAr()) ? RegArmaModel.of(dm, (IArimaModel)st.getStationaryModel()) : null;
        }
        return new RegArimaModel<M>(oldModel.y, newArima, oldModel.mean, oldModel.x, oldModel.missing, dm);
    }

    private RegArimaModel(DoubleSeq y, M arima, boolean mean, List<DoubleSeq> x, int[] missing, RegArmaModel<M> dmodel) {
        this.y = y;
        this.arima = arima;
        this.mean = mean;
        this.x = x;
        this.missing = missing;
        this.dmodel = dmodel;
    }

    public int getMissingValuesCount() {
        return this.missing.length;
    }

    public int getObservationsCount() {
        return this.y.length();
    }

    public int getActualObservationsCount() {
        return this.y.length() - this.missing.length;
    }

    public int getVariablesCount() {
        int nv = this.x.size();
        if (this.mean) {
            ++nv;
        }
        return nv;
    }

    public int getXCount() {
        return this.x.size();
    }

    @NonNull
    public DoubleSeq getY() {
        return this.y;
    }

    @NonNull
    public DoubleSeq originalY() {
        if (this.missing.length == 0) {
            return this.y;
        }
        double[] z = this.y.toArray();
        for (int i = 0; i < this.missing.length; ++i) {
            z[this.missing[i]] = Double.NaN;
        }
        return DoubleSeq.of((double[])z);
    }

    @NonNull
    public List<DoubleSeq> getX() {
        return this.x;
    }

    @NonNull
    public M arima() {
        return this.arima;
    }

    public boolean isMean() {
        return this.mean;
    }

    public FastMatrix variables() {
        int n = this.y.length();
        FastMatrix m = FastMatrix.make(n, this.x.size());
        double[] storage = m.getStorage();
        int pos = 0;
        for (DoubleSeq xcur : this.x) {
            xcur.copyTo(storage, pos);
            pos += n;
        }
        return m;
    }

    public Matrix allVariables() {
        int n = this.y.length();
        int m = this.x.size();
        if (this.mean) {
            ++m;
        }
        double[] storage = new double[n * m];
        int pos = 0;
        if (this.mean) {
            RegArimaUtility.meanRegressionVariable(this.arima.getNonStationaryAr(), n, storage, 0);
            pos += n;
        }
        for (DoubleSeq xcur : this.x) {
            xcur.copyTo(storage, pos);
            pos += n;
        }
        return Matrix.of((double[])storage, (int)n, (int)m);
    }

    @NonNull
    public int[] missing() {
        return this.missing.length == 0 ? NOMISSING : (int[])this.missing.clone();
    }

    public Builder<M> toBuilder() {
        Builder builder = new Builder();
        builder.y(this.y).arima(this.arima).meanCorrection(this.mean).missing(this.missing);
        for (DoubleSeq v : this.x) {
            builder.addX(v);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegArmaModel<M> differencedModel() {
        RegArmaModel<M> tmp = this.dmodel;
        if (tmp == null) {
            RegArimaModel regArimaModel = this;
            synchronized (regArimaModel) {
                tmp = this.dmodel;
                if (tmp == null) {
                    this.dmodel = tmp = RegArmaModel.of(this);
                }
            }
        }
        return tmp;
    }

    public static class Builder<M extends IArimaModel> {
        private DoubleSeq y;
        private M arima;
        private boolean mean;
        private final ArrayList<DoubleSeq> x = new ArrayList();
        private int[] missing;

        private Builder() {
        }

        public Builder y(DoubleSeq y) {
            this.y = y;
            return this;
        }

        public Builder arima(M arima) {
            this.arima = arima;
            return this;
        }

        public Builder meanCorrection(boolean mean) {
            this.mean = mean;
            return this;
        }

        public Builder addX(FastMatrix X) {
            if (X != null && !X.isEmpty()) {
                if (this.y.length() != X.getRowsCount()) {
                    throw new RuntimeException("Incompatible dimensions");
                }
                for (int i = 0; i < X.getColumnsCount(); ++i) {
                    this.x.add((DoubleSeq)X.column(i));
                }
            }
            return this;
        }

        public Builder addX(@NonNull DoubleSeq var) {
            if (var == null) {
                throw new NullPointerException("var is marked non-null but is null");
            }
            if (var.length() != this.y.length()) {
                throw new RuntimeException("Incompatible dimensions");
            }
            this.x.add(var);
            return this;
        }

        public Builder addX(DoubleSeq ... vars) {
            if (vars == null) {
                throw new NullPointerException("vars is marked non-null but is null");
            }
            for (DoubleSeq var : vars) {
                if (var.length() != this.y.length()) {
                    throw new RuntimeException("Incompatible dimensions");
                }
                this.x.add(var);
            }
            return this;
        }

        public Builder addX(@NonNull Collection<DoubleSeq> vars) {
            if (vars == null) {
                throw new NullPointerException("vars is marked non-null but is null");
            }
            for (DoubleSeq var : vars) {
                if (var.length() != this.y.length()) {
                    throw new RuntimeException("Incompatible dimensions");
                }
                this.x.add(var);
            }
            return this;
        }

        public Builder removeX(int pos) {
            this.x.remove(pos);
            return this;
        }

        public Builder missing(int ... missingPos) {
            this.missing = missingPos;
            return this;
        }

        public RegArimaModel<M> build() {
            if (this.y == null || this.arima == null) {
                throw new RuntimeException("Incomplete REGARIMA");
            }
            return new RegArimaModel<M>(this.y, this.arima, this.mean, Collections.unmodifiableList(this.x), this.missing == null ? NOMISSING : this.missing, null);
        }
    }
}

