/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions.levmar;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunction;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionPoint;
import jdplus.toolkit.base.core.math.functions.ssq.SsqFunctionMinimizer;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;

public class DogLegMinimizer
implements SsqFunctionMinimizer {
    static final int DEF_MAX_ITER = 20;
    static final double EPSILON = 1.0E-17;
    static final double DEF_STOP_THRESH = 1.0E-12;
    static final double DEF_LTRUSTED = 0.1;
    private int itmax = 20;
    private int iter = 0;
    private double eps1 = 1.0E-12;
    private double eps2 = 1.0E-12;
    private double eps2_sq = 1.0E-24;
    private double eps3 = 1.0E-12;
    private double ltrusted_ = 0.1;
    private double eps = 1.0E-5;
    private DataBlock g_;
    private ISsqFunction fn_;
    private ISsqFunctionPoint fcur_;
    private ISsqFunctionPoint ftry_;
    private DataBlock ecur_;
    private double Fcur_;
    private double Ftry_;
    private FastMatrix J;
    private FastMatrix JtJ;
    private double scale_;
    private double scale2_;
    private int stop;

    @Override
    public FastMatrix curvatureAtMinimum() {
        if (this.JtJ == null) {
            this.fcur_.ssqDerivatives().jacobian(this.J);
            this.JtJ = SymmetricMatrix.XtX(this.J);
        }
        return this.JtJ.times(2.0);
    }

    @Override
    public DoubleSeq gradientAtMinimum() {
        return this.fcur_.ssqDerivatives().gradient();
    }

    @Override
    public ISsqFunctionPoint getResult() {
        return this.fcur_;
    }

    @Override
    public double getObjective() {
        return this.Fcur_;
    }

    @Override
    public boolean minimize(ISsqFunctionPoint start) {
        this.fn_ = start.getSsqFunction();
        this.fcur_ = start;
        return this.calc();
    }

    private boolean iterate() {
        DataBlock np;
        if (!Double.isFinite(this.Fcur_)) {
            this.stop = 7;
            return false;
        }
        if (this.Fcur_ <= this.eps3 * this.scale2_) {
            this.stop = 6;
            return false;
        }
        this.fcur_.ssqDerivatives().jacobian(this.J);
        this.JtJ = SymmetricMatrix.XtX(this.J);
        double jdiag_ninf = this.JtJ.diagonal().normInf();
        this.g_.product(this.J.columnsIterator(), this.ecur_);
        double ngInf = this.g_.normInf();
        if (ngInf <= this.eps * this.scale_) {
            this.stop = 1;
            return false;
        }
        double ng2 = this.g_.ssq();
        double ng = Math.sqrt(ng2);
        DataBlock hgn = null;
        DataBlock hsd = DataBlock.of((DoubleSeq)this.g_);
        hsd.chs();
        DataBlock Jg = DataBlock.make(this.J.getRowsCount());
        Jg.product(this.J.rowsIterator(), this.g_);
        double alpha = ng2 / Jg.ssq();
        DataBlock a = DataBlock.of((DoubleSeq)hsd);
        a.mul(alpha);
        double na = a.norm2();
        double k = 0.0;
        do {
            FastMatrix A = this.JtJ.deepClone();
            if (k == 0.0) {
                k = 1.0E-6 * jdiag_ninf;
            } else {
                A.diagonal().add(k);
                k *= 10.0;
            }
            try {
                SymmetricMatrix.lcholesky(A);
                hgn = DataBlock.of((DoubleSeq)this.g_);
                LowerTriangularMatrix.solveLx(A, hgn);
                LowerTriangularMatrix.solvexL(A, hgn);
                hgn.chs();
            }
            catch (MatrixException err) {
                hgn = null;
            }
        } while (hgn == null && k < jdiag_ninf);
        if (hgn == null) {
            return false;
        }
        do {
            double dL;
            DataBlock hdl;
            double ro = 0.0;
            if (hgn.norm2() <= this.ltrusted_) {
                hdl = hgn;
                dL = -this.g_.dot(hdl);
            } else if (na >= this.ltrusted_) {
                hdl = DataBlock.of((DoubleSeq)hsd);
                hdl.mul(this.ltrusted_ / ng);
                dL = this.ltrusted_ * (2.0 * Math.abs(alpha) * ng - this.ltrusted_) / alpha;
            } else {
                DataBlock bma = DataBlock.of((DoubleSeq)hgn);
                bma.sub(a);
                double c = a.dot(bma);
                double nbma = bma.ssq();
                double z0 = this.ltrusted_ * this.ltrusted_ - a.ssq();
                double z1 = Math.sqrt(c * c + nbma * z0);
                double beta = c <= 0.0 ? (-c + z1) / nbma : z0 / (c + z1);
                dL = alpha * (1.0 - beta) * (1.0 - beta) * ng + beta * (2.0 - beta) * this.Fcur_;
                hdl = DataBlock.of((DoubleSeq)a);
                hdl.addAY(beta, bma);
            }
            if (!Double.isFinite(hdl.ssq())) {
                this.stop = 7;
                return false;
            }
            np = DataBlock.of(this.fcur_.getParameters());
            if (hdl.ssq() <= this.eps2 * (np.ssq() + this.eps2)) {
                this.stop = 2;
                return false;
            }
            np.add(hdl);
            boolean solved = this.fn_.getDomain().checkBoundaries((DoubleSeq)np);
            boolean accepted = false;
            if (solved) {
                this.ftry_ = this.fn_.ssqEvaluate((DoubleSeq)np);
                this.Ftry_ = this.ftry_.getSsqE();
                double dF = this.Fcur_ - this.Ftry_;
                ro = dF / dL;
                if (dF > 0.0) {
                    accepted = true;
                    this.fcur_ = this.ftry_;
                    this.Fcur_ = this.Ftry_;
                    this.ecur_ = DataBlock.of(this.fcur_.getE());
                }
            }
            if (accepted && ro > 0.75) {
                this.ltrusted_ = Math.max(this.ltrusted_, 3.0 * hdl.norm2());
            } else if (!accepted || ro < 0.25) {
                this.ltrusted_ *= 0.5;
            }
            if (!accepted) continue;
            return true;
        } while (!(this.ltrusted_ <= this.eps * (np.norm2() + this.eps2)));
        this.JtJ = null;
        return false;
    }

    @Override
    public int getIterationsCount() {
        return this.iter;
    }

    private boolean calc() {
        this.iter = 0;
        this.ecur_ = DataBlock.of(this.fcur_.getE());
        this.scale2_ = this.Fcur_ = this.fcur_.getSsqE();
        this.scale_ = Math.sqrt(this.Fcur_);
        this.ltrusted_ = 0.1;
        int n = this.ecur_.length();
        int m = this.fn_.getDomain().getDim();
        this.J = FastMatrix.make(n, m);
        this.g_ = DataBlock.make(m);
        while (this.iterate() && this.iter < this.itmax) {
            ++this.iter;
        }
        return this.stop != 7 && this.stop != 4;
    }
}

