% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.formulas.saturated.R
\name{make.formulas.saturated}
\alias{make.formulas.saturated}
\title{Creates a \code{formulas} Argument}
\usage{
make.formulas.saturated(
  data,
  blocks = mice::make.blocks(data),
  predictorMatrix = NULL,
  d = NULL
)
}
\arguments{
\item{data}{A \code{data.frame} with the source data.}

\item{blocks}{An optional specification for blocks of variables in the rows.
The default assigns each variable in its own block.}

\item{predictorMatrix}{A \code{predictorMatrix} specified by the user.}

\item{d}{maximum depth of interactions to be considered (1=no interactions, 2=two-way interactions, etc.)}
}
\value{
A list of formulas.
}
\description{
This helper function creates a valid \code{formulas} object.
The \code{formulas} object is an argument to the \code{mice::\link[mice]{mice}} function.
It is a list of formulas that specifies the target variables and the predictors
by means of the standard ~ operator. In contrast to \code{mice::\link[mice]{make.formulas}},
which creates main effects formulas, \code{make.formulas.saturated}
creates formulas including interaction effects.
}
\note{
A modification of \code{mice::\link[mice]{make.formulas}} by Stef van Buuren et al.
}
\examples{
## main effects model:
data(nhanes)
f1 <- make.formulas(nhanes)
f1

## saturated model:
f2 <- make.formulas.saturated(nhanes)
f2

}
\seealso{
\code{mice::\link[mice]{make.formulas}}
}
