% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhurdle.methods.R
\name{mhurdle.methods}
\alias{mhurdle.methods}
\alias{coef.mhurdle}
\alias{vcov.mhurdle}
\alias{logLik.mhurdle}
\alias{print.mhurdle}
\alias{summary.mhurdle}
\alias{print.summary.mhurdle}
\alias{predict.mhurdle}
\alias{update.mhurdle}
\alias{fitted.mhurdle}
\alias{effects.mhurdle}
\alias{coef.summary.mhurdle}
\alias{nobs.mhurdle}
\title{Methods for mhurdle fitted objects}
\usage{
\method{coef}{mhurdle}(
  object,
  which = c("all", "h1", "h2", "h3", "h4", "sd", "corr", "tr", "pos"),
  ...
)

\method{vcov}{mhurdle}(
  object,
  which = c("all", "h1", "h2", "h3", "h4", "sd", "corr", "tr", "pos"),
  ...
)

\method{logLik}{mhurdle}(object, naive = FALSE, ...)

\method{print}{mhurdle}(
  x,
  digits = max(3, getOption("digits") - 2),
  width = getOption("width"),
  ...
)

\method{summary}{mhurdle}(object, ...)

\method{coef}{summary.mhurdle}(
  object,
  which = c("all", "h1", "h2", "h3", "sd", "corr", "tr", "pos"),
  ...
)

\method{print}{summary.mhurdle}(
  x,
  digits = max(3, getOption("digits") - 2),
  width = getOption("width"),
  ...
)

\method{fitted}{mhurdle}(object, which = c("all", "zero", "positive"), mean = FALSE, ...)

\method{predict}{mhurdle}(object, newdata = NULL, what = c("E", "Ep", "p"), ...)

\method{update}{mhurdle}(object, new, ...)

\method{nobs}{mhurdle}(object, which = c("all", "null", "positive"), ...)

\method{effects}{mhurdle}(
  object,
  covariate = NULL,
  data = NULL,
  what = c("E", "Ep", "p"),
  reflevel = NULL,
  mean = FALSE,
  ...
)
}
\arguments{
\item{object, x}{an object of class \code{"mhurdle"},}

\item{which}{which coefficients or covariances should be extracted
? Those of the selection (\code{"h1"}), consumption
(\code{"h2"}) or purchase (\code{"h3"}) equation, the other
coefficients \code{"other"} (the standard error and the
coefficient of corr), the standard error (\code{"sigma"}) or
the coefficient of correlation (\code{"rho"}),}

\item{\dots}{further arguments.}

\item{naive}{a boolean, it \code{TRUE}, the likelihood of the naive
model is returned,}

\item{digits}{see \code{\link{print}},}

\item{width}{see \code{\link{print}},}

\item{mean}{if \code{TRUE}, the mean of the effects is returned,}

\item{newdata, data}{a \code{data.frame} for which the predictions
or the effectsshould be computed,}

\item{what}{for the \code{predict} and the \code{effects} method, the kind of
prediction, one of \code{E} \code{Ep} and \code{p} (respectively for expected
values in the censored sample, expected values in the truncated
sample and probability of positive values),}

\item{new}{an updated formula for the \code{update} method,}

\item{covariate}{the covariate for which the effect has to be
computed,}

\item{reflevel}{for the computation of effects for a factor, the
reference level,}
}
\description{
specific predict, fitted, coef, vcov, summary, ... for mhurdle
objects. In particular, these methods enables to extract the several parts of the model
}
