% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{vest}
\alias{vest}
\title{Add CSS/JS assets to HTML output}
\usage{
vest(feature = NULL, css = NULL, js = NULL)
}
\arguments{
\item{feature}{A character vector of features supported by CSS/JS, e.g.,
\code{c('article', 'callout')}. See the row names of \code{litedown:::assets} for all
available features. Each feature will be mapped to CSS/JS.}

\item{css, js}{Character vectors of CSS/JS assets.}
}
\value{
A vector of \verb{<link>} (CSS) or \verb{<script>} (JS) tags.
}
\description{
While CSS/JS assets can be set via the \code{css}/\code{js} keys under the \code{meta} field
of the \code{html} output format in YAML, this function provides another way to
add them, which can be called in a code chunk to dynamically add assets.
}
\examples{
litedown:::assets[, -1]
# add features
litedown::vest(c("copy-button", "tabsets"))
# add css/js directly
litedown::vest(css = "@tabsets", js = c("@tabsets", "@fold-details"))
}
