% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportions.R
\name{a_proportion_ci_logical}
\alias{a_proportion_ci_logical}
\title{Formatted Analysis Function For Proportion Confidence Interval for Logical}
\usage{
a_proportion_ci_logical(x, .alt_df, conf_level, method, formats)
}
\arguments{
\item{x}{(\code{logical})\cr including binary response values.}

\item{.alt_df}{(\code{data.frame})\cr alternative data frame used for denominator calculation.}

\item{conf_level}{(\code{numeric})\cr confidence level for the confidence interval.}

\item{method}{(\code{string})\cr please see \code{\link[tern:estimate_proportion]{tern::s_proportion()}} for possible
methods.}

\item{formats}{(\code{list})\cr including element \code{prop_ci} with the
required format. Note that the value is in percent already.}
}
\value{
The \code{\link[rtables:rcell]{rtables::rcell()}} result.
}
\description{
Formatted Analysis Function For Proportion Confidence Interval for Logical.
}
\examples{
a_proportion_ci_logical(
  x = DM$SEX == "F",
  .alt_df = DM,
  conf_level = 0.95,
  formats = list(prop_ci = jjcsformat_xx("xx.xx\% - xx.xx\%")),
  method = "wald"
)
}
