% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{orbi_get_example_files}
\alias{orbi_get_example_files}
\title{Get available example file(s)}
\usage{
orbi_get_example_files(
  filenames,
  download_raw_files = FALSE,
  download_always = FALSE
)
}
\arguments{
\item{filenames}{names of the example files}

\item{download_raw_files}{should the original raw files be downloaded? By default only cache files (raw.cache.zip) are downloaded as they are usually much smaller.
However, they will not work for retrieving additional spectra. To download the original spectra, switch to \code{download_raw_files = TRUE}}

\item{download_always}{whether to download files anew even if they already exist locally}
}
\value{
file path(s) that can be passed directly to \code{\link[=orbi_read_raw]{orbi_read_raw()}}
}
\description{
This function will provide the path(s) to example file(s).
If a requested file is not yet available locally but is available on https://github.com/isoverse/isodata, it will download it from there into local storage.
By default, it will download only cache files (.raw.cache.zip) instead of the original .raw files because the cache files are significantely smaller.
Todownload the original raw files instead, use \code{download_raw_files = TRUE}.
}
