% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.R
\name{orbi_filter_isotopocules}
\alias{orbi_filter_isotopocules}
\title{Filter isotopocules}
\usage{
orbi_filter_isotopocules(
  dataset,
  isotopocules = c(),
  keep_missing = FALSE,
  keep_unidentified = FALSE
)
}
\arguments{
\item{dataset}{An aggregated dataset or a data frame of peaks (i.e. works directly after \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}} as well as with a tibble from \link[=orbi_get_data]{orbi_get_data(peaks = everything())} or when reading from an IsoX file)}

\item{isotopocules}{if provided, only these isotopocules will be kept}

\item{keep_missing}{whether to keep missing isotopocules in the peaks list (i.e. those that should be there but are not), default is not to keep them}

\item{keep_unidentified}{whether to keep unidentified isotopocules in the peaks list (i.e. peaks that have not been identified as a specificic isotopocule), default is not to keep them}
}
\value{
the \code{dataset} but filtered for these isotopocules
}
\description{
This function helps filter out missing isotopcules, unidentified peaks, or select for specific isotopocule.
It can be called any time after \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}} or after reading from an isox file.
By default (i.e. if run without setting any parameters), it removes unidentified peaks and missing isotopcules and keeps all others.
}
