% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grangersearch.R
\name{glance.granger_result}
\alias{glance.granger_result}
\title{Glance at a granger_result Object}
\usage{
\method{glance}{granger_result}(x, ...)
}
\arguments{
\item{x}{A \code{granger_result} object.}

\item{...}{Additional arguments (ignored).}
}
\value{
A tibble with one row and columns:
\describe{
\item{nobs}{Integer. Number of observations.}
\item{lag}{Integer. VAR lag order used.}
\item{alpha}{Numeric. Significance level used.}
\item{test}{Character. Test type used.}
\item{bidirectional}{Logical. TRUE if causality detected in both directions.}
\item{x_causes_y}{Logical. TRUE if x Granger-causes y.}
\item{y_causes_x}{Logical. TRUE if y Granger-causes x.}
}
}
\description{
Returns a tibble with a single row containing model-level summary statistics.
Compatible with the broom package conventions.
}
\examples{
set.seed(123)
x <- cumsum(rnorm(100))
y <- c(0, x[1:99]) + rnorm(100, sd = 0.5)
result <- granger_causality_test(x = x, y = y)
glance(result)

}
