% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-title.R
\name{patch_title}
\alias{patch_title}
\alias{patch_titles}
\title{Add patch titles to plot borders}
\usage{
patch_title(
  top = waiver(),
  left = waiver(),
  bottom = waiver(),
  right = waiver()
)
}
\arguments{
\item{top, left, bottom, right}{A string specifying the title to be added to the
top, left, bottom, and right border of the plot.}
}
\value{
A \code{\link[ggplot2:labs]{labels}} object to be added to ggplot.
}
\description{
This function extends ggplot2's title functionality, allowing you to add
titles to each border of the plot: top, left, bottom, and right.
}
\details{
The appearance and alignment of these patch titles can be customized using
\link[ggplot2:theme]{theme()}:
\itemize{
\item \code{plot.patch_title}/\verb{plot.patch_title.*}: Controls the text appearance of
patch titles. By default, \code{plot.patch_title} inherit from \code{plot.title}, and
settings for each border will inherit from \code{plot.patch_title}, with the
exception of the \code{angle} property, which is not inherited.
\item \code{plot.patch_title.position}/\verb{plot.patch_title.position.*}: Determines the
alignment of the patch titles. By default, \code{plot.patch_title.position}
inherit from \code{plot.title.position}, and settings for each border will
inherit from \code{plot.patch_title}. The value \code{"panel"} aligns the patch
titles with the plot panels. Setting this to \code{"plot"} aligns the patch
title with the entire plot (excluding margins and plot tags).
}
}
\examples{
ggplot(mtcars) +
    geom_point(aes(mpg, disp)) +
    patch_title(
        top = "I'm top patch title",
        left = "I'm left patch title",
        bottom = "I'm bottom patch title",
        right = "I'm right patch title"
    )
}
