% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-design.R
\name{layout_design}
\alias{layout_design}
\title{Define the grid to compose plots in}
\usage{
layout_design(
  ncol = NA_real_,
  nrow = NA_real_,
  byrow = NA,
  widths = NULL,
  heights = NULL,
  area = waiver(),
  guides = NA_character_
)
}
\arguments{
\item{ncol, nrow}{The number of columns and rows in the grid. Defaults to
\code{NULL}. If both are \code{NULL}, the layout dimensions are determined
automatically using the same logic as \code{\link[ggplot2:facet_wrap]{facet_wrap()}}.}

\item{byrow}{A logical value indicating whether plots should be filled in
row-major order (\code{TRUE}) or column-major order (\code{FALSE}). Defaults to
\code{TRUE}.}

\item{widths, heights}{The relative widths and heights of each column and row
in the grid. These values are recycled to match the grid dimensions.  The
special value \code{NA} is treated as a unit of \verb{1null}, unless a fixed-aspect
plot is included — in that case, the affected dimension will expand or
contract to maintain the aspect ratio of the plot. Defaults to \code{NA}.}

\item{area}{A specification of the area layout. Can be defined either as a
character string or as a combination of calls to \code{\link[=area]{area()}}. Defaults to
\code{NULL}.}

\item{guides}{A string with one or more of \code{"t"}, \code{"l"}, \code{"b"}, \code{"r"}, and \code{"i"}
indicating which side of guide legends should be collected. Defaults to
\code{\link[ggplot2:waiver]{waiver()}}, which inherits from the parent layout. If
there is no parent layout, or if \code{NULL} is provided, no guides will be
collected.}
}
\value{
A \code{layout_design} object.
}
\description{
To control how different plots are laid out, you need to add a layout design
specification. If you are nesting grids, the layout is scoped to the current
nesting level.
}
\examples{
p1 <- ggplot(mtcars) +
    geom_point(aes(mpg, disp))
p2 <- ggplot(mtcars) +
    geom_boxplot(aes(gear, disp, group = gear))
p3 <- ggplot(mtcars) +
    geom_bar(aes(gear)) +
    facet_wrap(~cyl)
align_plots(p1, p2, p3) +
    layout_design(nrow = 1L)
align_plots(p1, p2, p3) +
    layout_design(ncol = 1L)
}
