% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filers.R
\name{get_filers_since_date}
\alias{get_filers_since_date}
\title{Retrieve Filers Since Date}
\usage{
get_filers_since_date(
  user_id = Sys.getenv("FFIEC_USER_ID"),
  bearer_token = Sys.getenv("FFIEC_BEARER_TOKEN"),
  reporting_period_end_date,
  last_update_date_time,
  as_data_frame = FALSE
)
}
\arguments{
\item{user_id}{(String) The UserID for authenticating against the FFIEC API}

\item{bearer_token}{(String) The Bearer Token for authenticating against the
FFIEC API}

\item{reporting_period_end_date}{(String) The reporting period end date,
formatted as "MM/DD/YYYY".}

\item{last_update_date_time}{(String) Filter for records updated
since this date/time. See \code{Details} for formatting options.}

\item{as_data_frame}{(Logical) Should the result be returned as a tibble?
Default is \code{FALSE}.}
}
\value{
A list containing the parsed JSON response from the API, where each
element in the list represents an RSSD ID value.  If
\code{as_data_frame = TRUE}, then the list is converted to a tibble (and
returned as such).
}
\description{
Retrieves filer information from the FFIEC Central Data
Repository API for filers updated since a specified date.
}
\details{
Set the \code{last_update_date_time} value to the last time you ran the
method to retrieve only those institutions that have filed a newer report.
Possible formatting options include:
\itemize{
\item "04/15/2025"
\item "2025-04-15 21:00:00.000"
\item "04/15/2025 9:00 PM"
}
}
\examples{
if (!no_creds_available()) {
  # Assume you have set the following environment variables:
  # - FFIEC_USER_ID
  # - FFIEC_BEARER_TOKEN

  # Retrieve filers since 2025-03-31, as of 2025-04-15 and return as a list
  get_filers_since_date(
    reporting_period_end_date = "03/31/2025",
    last_update_date_time = "04/15/2025"
  )

  # Retrieve filers since 2025-03-31, as of 2025-04-15 21:00:00.000 and return
  # as a tibble
  get_filers_since_date(
    reporting_period_end_date = "03/31/2025",
    last_update_date_time = "04/15/2025 21:00:00.000",
    as_data_frame = TRUE
  )
}
}
\references{
\url{https://cdr.ffiec.gov/public/Files/SIS611_-_Retrieve_Public_Data_via_Web_Service.pdf}
}
