% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normality.datatable.R
\name{normality.datatable}
\alias{normality.datatable}
\title{Raw normality per subgroup (Shapiro–Wilk) across factor combinations}
\usage{
normality.datatable(formula, data, force_factors = TRUE)
}
\arguments{
\item{formula}{A model formula \code{y ~ A + B (+ C ...)}.}

\item{data}{A data frame with the variables.}

\item{force_factors}{Logical; if TRUE, coerces RHS predictors to factors.}
}
\value{
A data.frame with rows per subgroup/cell. Columns: \code{Effect}, factor columns,
\code{count}, \code{W}, \code{p.shapiro} (4 decimals), \code{OK}.
}
\description{
Runs Shapiro–Wilk tests on the raw response within each subgroup for all non-empty
combinations of RHS factors (main effects and interaction cells).
}
\examples{
\dontrun{
normality.datatable(liking ~ gender + condition + age_cat, data = mimicry)
}
}
\seealso{
\code{\link{plan.diagnostics}}
}
