% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future.R
\name{futurepv}
\alias{futurepv}
\title{Calculate present value for a payoff in a single cohort with dynamic pricing across multiple timepoints}
\usage{
futurepv(tzero = 0, payoffs, prices, discrate)
}
\arguments{
\item{tzero}{Time at the date of calculation, to be used in lookup in prices vector}

\item{payoffs}{Vector of payoffs of interest (numeric vector)}

\item{prices}{Vector of price indices through the time horizon of interest}

\item{discrate}{Discount rate per timestep, corresponding to price index}
}
\value{
A tibble of class "dynpv" with the following columns:
\itemize{
\item \code{j}: Time at which patients began treatment
\item \code{k}: Time since patients began treatment
\item \code{l}: Time offset for the price index (from \code{tzero})
\item \code{t}: Equals \eqn{j+k-1}
\item \code{uj}: Uptake of patients beginning treatment at time \eqn{j} (from \code{uptakes})
\item \code{pk}: Cashflow amount in today's money in respect of patients at time \eqn{k} since starting treatment (from \code{payoffs})
\item \code{R}: Index of prices over time \eqn{l+t} (from \code{prices})
\item \code{v}: Discounting factors, \eqn{(1+i)^{1-t}}, where \code{i} is the discount rate per timestep
\item \code{pv}: Present value, \eqn{PV(j,k,l)}
}
}
\description{
Present value of a series of payoffs for a single given cohort, entering at given future time, allowing for dynamic pricing. This function is a wrapper for \code{\link[=dynpv]{dynpv()}} restricted to evaluation of a single cohort.
}
\examples{
library(dplyr)

# Obtain dataset
democe <- get_dynfields(
   heemodel = oncpsm,
   payoffs = c("cost_daq_new", "cost_total", "qaly"),
   discount = "disc"
   )

# Obtain discount rate
discrate <- get_param_value(oncpsm, "disc")

# Obtain payoff vector of interest
payoffs <- democe |>
   filter(int=="new") |>
   mutate(cost_oth_rup = cost_total_rup - cost_daq_new_rup)
Nt <- nrow(payoffs)

# Run calculation for times 0-9
fpv <- futurepv(
  tzero = (0:9)*52,
  payoffs = payoffs$cost_oth_rup,
  prices = 1.001^(1:(2*Nt)-1), # Approx 5.3\% every 52 steps
  discrate = 0.001 + discrate
)
fpv
summary(fpv)
}
\seealso{
\code{\link[=dynpv]{dynpv()}}
}
