% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_event.R
\name{add_event}
\alias{add_event}
\title{Add eventlines to the chart}
\usage{
add_event(data, ...)
}
\arguments{
\item{data}{a \link{data.frame}-type object with \code{index}, \code{event}
and \code{color} columns.}

\item{...}{For internal use. Please ignore.}
}
\value{
A \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-object with \code{shapes} and \code{annotations}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A high-level \code{\link[plotly:layout]{plotly::layout()}}-function.
The function adds \code{shapes} and \code{annotations} to the main \code{\link[=chart]{chart()}}.
}
\details{
The \link{data.frame} must include the following columns,
\itemize{
\item \code{index} \link{integer} or \link{date}: corresponding to the event timing.
\item \code{event} \link{character}: the event label.
\item \code{color} \link{character}: the color of the event
}
}
\examples{
# script start;

# 1) Generate random events
# of buys and sells and convert
# to data.frame
#
# Note: tibbles, data.tables are also supported
# but only base R is shown here to avoid
# too many dependencies
set.seed(1903)
event_data <- cryptoQuotes::ATOM[
  sample(
    x = 1:nrow(cryptoQuotes::ATOM),
    size = 2
  )
]

# 1.1) Extract the index
# from the event data
index <- zoo::index(
  event_data
)

# 1.2) Convert the coredata
# into a data.frame
event_data <- as.data.frame(
  zoo::coredata(
    event_data
  )
)

# 1.3) Add the index into the data.frame
# case insensitive
event_data$index <- index

# 1.4) add events to the data.
# here we use Buys and Sells.
event_data$event <- rep(
  x = c('Buy', 'Sell'),
  lenght.out = nrow(event_data)
)

# 1.5) add colors based
# on the event; here buy is colored
# darkgrey, and if the position is closed
# with profit the color is green
event_data$color <- ifelse(
  event_data$event == 'Buy',
  yes = 'darkgrey',
  no = ifelse(
    test = subset(
      x = event_data,
      event == 'Buy'
    )$close <
      subset(x = event_data, event == 'Sell')$close,
    yes = 'green',
    no = 'red'
  )
)

# 1.6) modify the event to add
# closing price at each event
event_data$event <- paste0(
  event_data$event,
  ' @',
  event_data$close
)

# 2) Chart the the klines
# and add the buy and sell events
cryptoQuotes::chart(
  ticker = cryptoQuotes::ATOM,
  main = cryptoQuotes::kline(),
  sub = list(
    cryptoQuotes::volume()
  ),
  indicator = list(
    cryptoQuotes::bollinger_bands()
  ),
  event_data = event_data,
  options = list(
    dark = TRUE,
    deficiency = FALSE
  )
)

# script end;
}
\seealso{
Other chart indicators: 
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{chart}()},
\code{\link{dema}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{fgi}()},
\code{\link{hma}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{sma}()},
\code{\link{smi}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other subchart indicators: 
\code{\link{fgi}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{smi}()},
\code{\link{volume}()}

Other main chart indicators: 
\code{\link{alma}()},
\code{\link{bollinger_bands}()},
\code{\link{dema}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{hma}()},
\code{\link{sma}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}
}
\author{
Serkan Korkmaz
}
\concept{chart indicators}
\concept{main chart indicators}
\concept{subchart indicators}
\keyword{internal}
