% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{styles_break_even_exit_yield}
\alias{styles_break_even_exit_yield}
\title{Break-even exit yield for a target leveraged equity IRR, by style}
\usage{
styles_break_even_exit_yield(
  styles,
  target_irr,
  interval = c(0.03, 0.1),
  config_dir = system.file("extdata", package = "cre.dcf")
)
}
\arguments{
\item{styles}{Character vector of style identifiers.}

\item{target_irr}{Numeric, target leveraged equity IRR to hit (in decimal).}

\item{interval}{Numeric vector of length 2 giving the bracketing interval
for the absolute exit yield (e.g. \code{c(0.03, 0.10)} for 3\%–10\%).}

\item{config_dir}{Directory where preset YAML files are stored.}
}
\value{
A tibble with columns:
\itemize{
\item \code{style} (character),
\item \code{target_irr} (numeric),
\item \code{be_exit_yield} (numeric, break-even exit yield in decimal, or \code{NA}
if no root was found in \code{interval}).
}
}
\description{
For each style, this helper solves (via \code{\link[=uniroot]{uniroot()}}) for the exit yield
that delivers a specified target leveraged equity IRR, holding all other
assumptions of the preset constant.
}
\details{
It proceeds by:
\itemize{
\item reading the YAML preset,
\item defining a root-finding function that, for a candidate absolute exit
yield, adjusts \code{exit_yield_spread_bps} accordingly,
\item calling \code{\link[=run_case]{run_case()}} and returning the difference between the resulting
equity IRR and \code{target_irr},
\item bracketing the root over a user-specified interval.
}

The lower the break-even exit yield, the tighter the exit_pricing
assumption that must be met to reach the hurdle, and the more the style
depends on favourable market_conditions at sale.
}
