\name{vacs_cci_score}
\alias{vacs_cci_score}
\title{
Veterans Aging Cohort Study - Charlson Comorbidity Index (VACS-CCI)
}
\description{
Calculates the VACS-CCI score, which adapts the Charlson Comorbidity Index for use in HIV-positive populations (and general populations) within the Veterans Aging Cohort Study context. It predicts all-cause mortality by summing weights for age and 17 specific comorbid conditions.
}
\usage{
vacs_cci_score(age, sex, metastatic_cancer, aids, mild_liver_disease,
               moderate_severe_liver_disease, chronic_pulmonary_disease,
               dementia, hemiplegia, severe_kidney_disease, mild_kidney_disease,
               history_mi, congestive_heart_failure, peripheral_vascular_disease,
               cerebrovascular_disease, peptic_ulcer_disease,
               diabetes_uncomplicated, diabetes_complicated, rheumatic_disease,
               non_metastatic_cancer)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<50: 0 pts.
50-59: +1 pt.
60-69: +2 pts.
70-79: +3 pts.
>=80: +4 pts.
}
  \item{sex}{
String. Patient sex ("male" or "female"). (Not weighted in score but part of demographic input).
}
  \item{metastatic_cancer}{
Numeric (0 or 1). Metastatic solid tumor. (1 = Yes, +6 pts).
}
  \item{aids}{
Numeric (0 or 1). AIDS diagnosis (not just HIV+). (1 = Yes, +6 pts).
}
  \item{mild_liver_disease}{
Numeric (0 or 1). Mild liver disease (e.g., chronic hepatitis, cirrhosis without portal hypertension). (1 = Yes, +2 pts). (Do not count if Moderate/Severe selected).
}
  \item{moderate_severe_liver_disease}{
Numeric (0 or 1). Moderate to severe liver disease (e.g., cirrhosis with portal hypertension, varices). (1 = Yes, +3 pts).
}
  \item{chronic_pulmonary_disease}{
Numeric (0 or 1). Chronic pulmonary disease (COPD). (1 = Yes, +1 pt).
}
  \item{dementia}{
Numeric (0 or 1). Dementia. (1 = Yes, +1 pt).
}
  \item{hemiplegia}{
Numeric (0 or 1). Hemiplegia or paraplegia. (1 = Yes, +2 pts).
}
  \item{severe_kidney_disease}{
Numeric (0 or 1). Moderate to severe kidney disease. (1 = Yes, +2 pts).
}
  \item{mild_kidney_disease}{
Numeric (0 or 1). Mild kidney disease. (1 = Yes, +1 pt). (Do not count if Severe selected).
}
  \item{history_mi}{
Numeric (0 or 1). Myocardial infarction. (1 = Yes, +1 pt).
}
  \item{congestive_heart_failure}{
Numeric (0 or 1). Congestive heart failure. (1 = Yes, +1 pt).
}
  \item{peripheral_vascular_disease}{
Numeric (0 or 1). Peripheral vascular disease. (1 = Yes, +1 pt).
}
  \item{cerebrovascular_disease}{
Numeric (0 or 1). Cerebrovascular disease. (1 = Yes, +1 pt).
}
  \item{peptic_ulcer_disease}{
Numeric (0 or 1). Peptic ulcer disease. (1 = Yes, +1 pt).
}
  \item{diabetes_uncomplicated}{
Numeric (0 or 1). Diabetes without chronic complications. (1 = Yes, +1 pt).
}
  \item{diabetes_complicated}{
Numeric (0 or 1). Diabetes with chronic complications. (1 = Yes, +2 pts). (Do not count Uncomplicated if Complicated selected).
}
  \item{rheumatic_disease}{
Numeric (0 or 1). Connective tissue/Rheumatic disease. (1 = Yes, +1 pt).
}
  \item{non_metastatic_cancer}{
Numeric (0 or 1). Any malignancy (including lymphoma/leukemia), except metastatic solid tumor or non-melanoma skin cancer. (1 = Yes, +2 pts).
}
}
\value{
A list containing:
\item{VACS_CCI_Score}{The calculated total score.}
\item{Interpretation}{Context regarding mortality risk prediction.}
}
\references{
Charlson ME, Pompei P, Ales KL, MacKenzie CR. A new method of classifying prognostic comorbidity in longitudinal studies: development and validation. J Chronic Dis. 1987;40(5):373-383. doi:10.1016/0021-9681(87)90171-8
Justice AC, et al. (Veterans Aging Cohort Study).
}
\examples{

# Example 1: High Risk
# 65yo (+2), Metastatic Cancer (+6), COPD (+1)
# Score = 9
vacs_cci_score(65, "male", 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

# Example 2: Low Risk
# 45yo (0), Uncomplicated Diabetes (+1)
# Score = 1
vacs_cci_score(45, "female", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0)
}
