\name{rome_iv_functional_constipation}
\alias{rome_iv_functional_constipation}
\title{
Rome IV Diagnostic Criteria for Functional Constipation
}
\description{
Evaluates the Rome IV criteria for diagnosing Functional Constipation in adults. Diagnosis requires the presence of at least two of the six specified symptoms in at least 25\% of defecations (over the last 3 months with symptom onset at least 6 months prior) AND the absence of sufficient criteria for Irritable Bowel Syndrome (IBS).
}
\usage{
rome_iv_functional_constipation(stool_frequency_lt_2_week, straining_ge_25_percent,
                                lumpy_hard_stool_ge_25_percent,
                                sensation_incomplete_evacuation_ge_25_percent,
                                sensation_anorectal_blockage_ge_25_percent,
                                manual_maneuver_ge_25_percent,
                                loose_stool_absent, sufficient_criteria_met)
}
\arguments{
  \item{stool_frequency_lt_2_week}{
Numeric (0 or 1). Less than 3 spontaneous bowel movements per week. (1 = Yes).
}
  \item{straining_ge_25_percent}{
Numeric (0 or 1). Straining during at least 25\% of defecations. (1 = Yes).
}
  \item{lumpy_hard_stool_ge_25_percent}{
Numeric (0 or 1). Lumpy or hard stools (Bristol Stool Form Scale 1 or 2) in at least 25\% of defecations. (1 = Yes).
}
  \item{sensation_incomplete_evacuation_ge_25_percent}{
Numeric (0 or 1). Sensation of incomplete evacuation in at least 25\% of defecations. (1 = Yes).
}
  \item{sensation_anorectal_blockage_ge_25_percent}{
Numeric (0 or 1). Sensation of anorectal obstruction/blockage in at least 25\% of defecations. (1 = Yes).
}
  \item{manual_maneuver_ge_25_percent}{
Numeric (0 or 1). Manual maneuvers to facilitate at least 25\% of defecations (e.g., digital evacuation, support of the pelvic floor). (1 = Yes).
}
  \item{loose_stool_absent}{
Numeric (0 or 1). Loose stools are rarely present without the use of laxatives. (1 = Yes). This is a required exclusion of IBS-D.
}
  \item{sufficient_criteria_met}{
Numeric (0 or 1). Do at least two of the six bulleted criteria (Q1-Q6) occur? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Functional Constipation" or "Criteria Not Met".}
\item{Criteria_Count}{The number of positive criteria out of the six specified symptoms.}
}
\references{
Lacy BE, Mearin F, Chang L, et al. Bowel Disorders. Gastroenterology. 2016;150:1393-1407. doi:10.1053/j.gastro.2016.02.031
}
\examples{

# Example 1: Diagnosis Met
# <3 stools/week, Straining, Hard stools,
#Incomplete evacuation. No loose stools. Sufficient criteria met.
rome_iv_functional_constipation(1, 1, 1, 1, 0, 0, 1, 1)

# Example 2: Not Met (Loose stools present)
# All criteria met except loose stools are present (0)
rome_iv_functional_constipation(1, 1, 1, 0, 0, 0, 0, 1)
}
