\name{reticulocyte_indices}
\alias{reticulocyte_indices}
\title{
Absolute Reticulocyte Count & Reticulocyte Index
}
\description{
Calculates hematological indices to assess bone marrow response to anemia.
1. **Absolute Reticulocyte Count (ARC):** Actual number of reticulocytes per volume of blood.
2. **Reticulocyte Index (RI):** Corrects the reticulocyte count for the degree of anemia (Hematocrit).
3. **Reticulocyte Production Index (RPI):** Further corrects the RI for the premature release of reticulocytes from the marrow (Maturation Shift), providing the most accurate assessment of effective RBC production.
}
\usage{
reticulocyte_indices(retic_percent, rbc_count_million,
                     hematocrit_percent, normal_hct = 45)
}
\arguments{
  \item{retic_percent}{
Numeric. The percentage of red blood cells that are reticulocytes (e.g., 2.5).
}
  \item{rbc_count_million}{
Numeric. The Red Blood Cell count in millions/uL (or 10^12/L). (e.g., 3.5).
}
  \item{hematocrit_percent}{
Numeric. The patient's Hematocrit percentage (e.g., 30).
}
  \item{normal_hct}{
Numeric. The expected normal Hematocrit. Defaults to 45\%.
}
}
\value{
A list containing:
\item{Absolute_Reticulocyte_Count}{Total reticulocytes (cells/uL).}
\item{Reticulocyte_Index}{Corrected count based on hematocrit reduction.}
\item{Reticulocyte_Production_Index}{The RI corrected for maturation time (shift correction).}
\item{Marrow_Response}{Interpretation of the RPI (Adequate > 3, Inadequate < 2).}
}
\references{
Hillman RS, Finch CA. Red Cell Manual. 7th ed. Philadelphia, Pa: FA Davis Co; 1996.
}
\examples{

# Example 1: Hemolytic Anemia (Appropriate Response)
# Retic 15\%, RBC 2.5 M/uL, Hct 25\%
# ARC = 375,000; RI = 8.33; RPI = 8.33 / 2.0 = 4.16 (Adequate)
reticulocyte_indices(15, 2.5, 25)

# Example 2: Hypoproliferative Anemia (Inadequate Response)
# Retic 2\%, RBC 3.0 M/uL, Hct 28\%
# ARC = 60,000; RI = 1.24; RPI = 1.24 / 2.0 = 0.62 (Inadequate)
reticulocyte_indices(2, 3.0, 28)
}
